/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.command;

import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.ErrorCode;
import migratedb.v1.core.api.ErrorDetails;
import migratedb.v1.core.api.callback.Event;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.callback.CallbackExecutor;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.database.base.Session;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.api.output.CommandResultFactory;
import migratedb.v1.core.api.output.ValidateOutput;
import migratedb.v1.core.api.output.ValidateResult;
import migratedb.v1.core.api.resolver.MigrationResolver;
import migratedb.v1.core.internal.info.MigrationInfoServiceImpl;
import migratedb.v1.core.internal.info.ValidationContext;
import migratedb.v1.core.internal.info.ValidationMatch;
import migratedb.v1.core.internal.jdbc.ExecutionTemplateFactory;
import migratedb.v1.core.internal.schemahistory.SchemaHistory;
import migratedb.v1.core.internal.util.DateTimeUtils;
import migratedb.v1.core.internal.util.StopWatch;

public class DbValidate {
    private static final Log LOG = Log.getLog(DbValidate.class);
    private final SchemaHistory schemaHistory;
    private final Schema schema;
    private final MigrationResolver migrationResolver;
    private final Session session;
    private final Configuration configuration;
    private final boolean allowPending;
    private final CallbackExecutor callbackExecutor;
    private final Database database;

    public DbValidate(Database database, SchemaHistory schemaHistory, Schema schema, MigrationResolver migrationResolver, Configuration configuration, boolean allowPending, CallbackExecutor callbackExecutor) {
        this.database = database;
        this.session = database.getMainSession();
        this.schemaHistory = schemaHistory;
        this.schema = schema;
        this.migrationResolver = migrationResolver;
        this.configuration = configuration;
        this.allowPending = allowPending;
        this.callbackExecutor = callbackExecutor;
    }

    public ValidateResult validate() {
        if (!this.schema.exists()) {
            if (!this.migrationResolver.resolveMigrations(() -> this.configuration).isEmpty() && !this.allowPending) {
                String validationErrorMessage = "Schema " + this.schema + " doesn't exist yet";
                ErrorDetails validationError = new ErrorDetails(ErrorCode.SCHEMA_DOES_NOT_EXIST, validationErrorMessage);
                return CommandResultFactory.createValidateResult(this.database.getCatalog(), validationError, 0, null, new ArrayList<String>());
            }
            return CommandResultFactory.createValidateResult(this.database.getCatalog(), null, 0, null, new ArrayList<String>());
        }
        this.callbackExecutor.onEvent(Event.BEFORE_VALIDATE);
        LOG.debug("Validating migrations ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        CountAndInvalidMigrations result = ExecutionTemplateFactory.createExecutionTemplate(this.session.getJdbcConnection(), this.database).execute(() -> {
            ValidationContext validationContext = new ValidationContext(this.configuration).with(ValidationMatch.PENDING, this.allowPending);
            MigrationInfoServiceImpl migrationInfoService = new MigrationInfoServiceImpl(this.migrationResolver, this.schemaHistory, this.database, this.configuration, this.configuration.getTarget(), this.configuration.getCherryPick(), validationContext);
            migrationInfoService.refresh();
            int count = migrationInfoService.all().length;
            List<ValidateOutput> invalidMigrations = migrationInfoService.validate();
            return new CountAndInvalidMigrations(count, invalidMigrations);
        });
        stopWatch.stop();
        ArrayList<String> warnings = new ArrayList<String>();
        List<ValidateOutput> invalidMigrations = result.invalidMigrations;
        ErrorDetails validationError = null;
        int count = 0;
        if (invalidMigrations.isEmpty()) {
            count = result.count;
            if (count == 1) {
                LOG.info(String.format("Successfully validated 1 migration (execution time %s)", DateTimeUtils.formatDuration(stopWatch.getTotalTimeMillis())));
            } else {
                LOG.info(String.format("Successfully validated %d migrations (execution time %s)", count, DateTimeUtils.formatDuration(stopWatch.getTotalTimeMillis())));
                if (count == 0) {
                    String noMigrationsWarning = "No migrations found. Are your locations set up correctly?";
                    warnings.add(noMigrationsWarning);
                    LOG.warn(noMigrationsWarning);
                }
            }
            this.callbackExecutor.onEvent(Event.AFTER_VALIDATE);
        } else {
            validationError = new ErrorDetails(ErrorCode.VALIDATE_ERROR, "Migrations have failed validation");
            this.callbackExecutor.onEvent(Event.AFTER_VALIDATE_ERROR);
        }
        return CommandResultFactory.createValidateResult(this.database.getCatalog(), validationError, count, invalidMigrations, warnings);
    }

    private static class CountAndInvalidMigrations {
        public final int count;
        public final List<ValidateOutput> invalidMigrations;

        private CountAndInvalidMigrations(int count, List<ValidateOutput> invalidMigrations) {
            this.count = count;
            this.invalidMigrations = invalidMigrations;
        }
    }
}

