/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.command;

import java.util.Objects;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrationInfo;
import migratedb.v1.core.api.MigrationState;
import migratedb.v1.core.api.TargetVersion;
import migratedb.v1.core.api.callback.Event;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.callback.CallbackExecutor;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Session;
import migratedb.v1.core.api.internal.schemahistory.AppliedMigration;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.api.output.CommandResultFactory;
import migratedb.v1.core.api.output.CompletedRepairActions;
import migratedb.v1.core.api.output.RepairResult;
import migratedb.v1.core.api.resolver.MigrationResolver;
import migratedb.v1.core.api.resolver.ResolvedMigration;
import migratedb.v1.core.internal.info.MigrationInfoServiceImpl;
import migratedb.v1.core.internal.info.ValidationContext;
import migratedb.v1.core.internal.jdbc.ExecutionTemplateFactory;
import migratedb.v1.core.internal.schemahistory.SchemaHistory;
import migratedb.v1.core.internal.util.DateTimeUtils;
import migratedb.v1.core.internal.util.StopWatch;

public class DbRepair {
    private static final Log LOG = Log.getLog(DbRepair.class);
    private final Session session;
    private final MigrationInfoServiceImpl migrationInfoService;
    private final SchemaHistory schemaHistory;
    private final CallbackExecutor callbackExecutor;
    private final Database database;
    private final RepairResult repairResult;
    private final Configuration configuration;

    public DbRepair(Database database, MigrationResolver migrationResolver, SchemaHistory schemaHistory, CallbackExecutor callbackExecutor, Configuration configuration) {
        this.database = database;
        this.session = database.getMainSession();
        this.schemaHistory = schemaHistory;
        this.callbackExecutor = callbackExecutor;
        this.configuration = configuration;
        this.migrationInfoService = new MigrationInfoServiceImpl(migrationResolver, schemaHistory, database, configuration, TargetVersion.LATEST, configuration.getCherryPick(), ValidationContext.allAllowed());
        this.repairResult = CommandResultFactory.createRepairResult(configuration, database);
    }

    public RepairResult repair() {
        CompletedRepairActions repairActions;
        this.callbackExecutor.onEvent(Event.BEFORE_REPAIR);
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            repairActions = ExecutionTemplateFactory.createExecutionTemplate(this.session.getJdbcConnection(), this.database).execute(() -> {
                CompletedRepairActions completedActions = new CompletedRepairActions();
                completedActions.removedFailedMigrations = this.schemaHistory.removeFailedMigrations(this.repairResult, this.configuration.getCherryPick());
                this.migrationInfoService.refresh();
                completedActions.deletedMissingMigrations = this.markUnavailableMigrationsAsDeleted();
                completedActions.alignedAppliedMigrationChecksums = this.alignAppliedMigrationsWithResolvedMigrations();
                return completedActions;
            });
            stopWatch.stop();
            LOG.info("Successfully repaired schema history table " + this.schemaHistory + " (execution time " + DateTimeUtils.formatDuration(stopWatch.getTotalTimeMillis()) + ").");
            if (repairActions.deletedMissingMigrations) {
                LOG.info("Please ensure the previous contents of the deleted migrations are removed from the database, or moved into an existing migration.");
            }
            if (repairActions.removedFailedMigrations && !this.database.supportsDdlTransactions()) {
                LOG.info("Manual cleanup of the remaining effects of the failed migration may still be required.");
            }
        }
        catch (MigrateDbException e) {
            this.callbackExecutor.onEvent(Event.AFTER_REPAIR_ERROR);
            throw e;
        }
        this.callbackExecutor.onEvent(Event.AFTER_REPAIR);
        this.repairResult.setRepairActions(repairActions);
        return this.repairResult;
    }

    private boolean markUnavailableMigrationsAsDeleted() {
        boolean removed = false;
        for (MigrationInfo migrationInfo : this.migrationInfoService.all()) {
            if (migrationInfo.getType().isExclusiveToAppliedMigrations()) continue;
            AppliedMigration applied = migrationInfo.getAppliedMigration();
            MigrationState state = migrationInfo.getState();
            boolean shouldDelete = state.is(MigrationState.Category.MISSING) && !state.is(MigrationState.Category.FUTURE);
            boolean isIgnoredByPattern = this.configuration.getIgnoreMigrationPatterns().stream().anyMatch(p -> p.matchesMigration(migrationInfo.getVersion() != null, state));
            if (!shouldDelete || isIgnoredByPattern) continue;
            this.schemaHistory.delete(applied);
            removed = true;
            this.repairResult.migrationsDeleted.add(CommandResultFactory.createRepairOutput(migrationInfo));
        }
        return removed;
    }

    private boolean alignAppliedMigrationsWithResolvedMigrations() {
        boolean repaired = false;
        for (MigrationInfo migrationInfo : this.migrationInfoService.all()) {
            ResolvedMigration resolved = migrationInfo.getResolvedMigration();
            AppliedMigration applied = migrationInfo.getAppliedMigration();
            if (resolved != null && resolved.getVersion() != null && applied != null && !applied.getType().isExclusiveToAppliedMigrations() && migrationInfo.getState() != MigrationState.IGNORED && this.updateNeeded(resolved, applied)) {
                this.schemaHistory.update(applied, resolved);
                repaired = true;
                this.repairResult.migrationsAligned.add(CommandResultFactory.createRepairOutput(migrationInfo));
            }
            if (resolved == null || resolved.getVersion() != null || applied == null || applied.getType().isExclusiveToAppliedMigrations() || migrationInfo.getState() == MigrationState.IGNORED || !resolved.checksumMatches(applied.getChecksum())) continue;
            this.schemaHistory.update(applied, resolved);
            repaired = true;
            this.repairResult.migrationsAligned.add(CommandResultFactory.createRepairOutput(migrationInfo));
        }
        return repaired;
    }

    private boolean updateNeeded(ResolvedMigration resolved, AppliedMigration applied) {
        return this.checksumUpdateNeeded(resolved, applied) || this.descriptionUpdateNeeded(resolved, applied) || this.typeUpdateNeeded(resolved, applied);
    }

    private boolean checksumUpdateNeeded(ResolvedMigration resolved, AppliedMigration applied) {
        return !resolved.checksumMatches(applied.getChecksum());
    }

    private boolean descriptionUpdateNeeded(ResolvedMigration resolved, AppliedMigration applied) {
        if (!this.database.supportsEmptyMigrationDescription() && "".equals(resolved.getDescription())) {
            return !Objects.equals("<< no description >>", applied.getDescription());
        }
        return !Objects.equals(resolved.getDescription(), applied.getDescription());
    }

    private boolean typeUpdateNeeded(ResolvedMigration resolved, AppliedMigration applied) {
        return !Objects.equals((Object)resolved.getType(), (Object)applied.getType());
    }
}

