/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.command;

import java.util.EnumSet;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrationInfoService;
import migratedb.v1.core.api.callback.Event;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.callback.CallbackExecutor;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.resolver.MigrationResolver;
import migratedb.v1.core.internal.info.MigrationInfoServiceImpl;
import migratedb.v1.core.internal.info.ValidationContext;
import migratedb.v1.core.internal.info.ValidationMatch;
import migratedb.v1.core.internal.schemahistory.SchemaHistory;

public class DbInfo {
    private final MigrationResolver migrationResolver;
    private final SchemaHistory schemaHistory;
    private final Configuration configuration;
    private final Database database;
    private final CallbackExecutor callbackExecutor;
    private final Schema[] schemas;

    public DbInfo(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Configuration configuration, Database database, CallbackExecutor callbackExecutor, Schema[] schemas) {
        this.migrationResolver = migrationResolver;
        this.schemaHistory = schemaHistory;
        this.configuration = configuration;
        this.database = database;
        this.callbackExecutor = callbackExecutor;
        this.schemas = schemas;
    }

    public MigrationInfoService info() {
        MigrationInfoServiceImpl migrationInfoService;
        this.callbackExecutor.onEvent(Event.BEFORE_INFO);
        try {
            EnumSet<ValidationMatch> allowedMatches = EnumSet.allOf(ValidationMatch.class);
            if (!this.configuration.isOutOfOrder()) {
                allowedMatches.remove((Object)ValidationMatch.OUT_OF_ORDER);
            }
            migrationInfoService = new MigrationInfoServiceImpl(this.migrationResolver, this.schemaHistory, this.database, this.configuration, this.configuration.getTarget(), this.configuration.getCherryPick(), new ValidationContext(allowedMatches));
            migrationInfoService.refresh();
            migrationInfoService.setAllSchemasEmpty(this.schemas);
        }
        catch (MigrateDbException e) {
            this.callbackExecutor.onEvent(Event.AFTER_INFO_ERROR);
            throw e;
        }
        this.callbackExecutor.onEvent(Event.AFTER_INFO);
        return migrationInfoService;
    }
}

