/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.callback;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrationInfo;
import migratedb.v1.core.api.callback.Callback;
import migratedb.v1.core.api.callback.Context;
import migratedb.v1.core.api.callback.Event;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.callback.CallbackExecutor;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.database.base.Session;
import migratedb.v1.core.api.output.OperationResult;
import migratedb.v1.core.internal.callback.SimpleContext;
import migratedb.v1.core.internal.jdbc.ExecutionTemplateFactory;

public class DefaultCallbackExecutor
implements CallbackExecutor {
    private final Configuration configuration;
    private final Database database;
    private final Schema schema;
    private final List<Callback> callbacks;
    private MigrationInfo migrationInfo;

    public DefaultCallbackExecutor(Configuration configuration, Database database, Schema schema, Collection<Callback> callbacks) {
        this.configuration = configuration;
        this.database = database;
        this.schema = schema;
        this.callbacks = new ArrayList<Callback>(callbacks);
        this.callbacks.sort(Comparator.comparing(Callback::getCallbackName));
    }

    @Override
    public void onEvent(Event event) {
        this.execute(event, this.database.getMainSession());
    }

    @Override
    public void onMigrateEvent(Event event) {
        this.execute(event, this.database.getMigrationSession());
    }

    @Override
    public void setMigrationInfo(MigrationInfo migrationInfo) {
        this.migrationInfo = migrationInfo;
    }

    @Override
    public void onEachMigrateEvent(Event event) {
        SimpleContext context = new SimpleContext(this.configuration, this.database.getMigrationSession(), this.migrationInfo, null);
        for (Callback callback : this.callbacks) {
            if (!callback.supports(event, context)) continue;
            callback.handle(event, context);
        }
    }

    @Override
    public void onOperationFinishEvent(Event event, OperationResult operationResult) {
        SimpleContext context = new SimpleContext(this.configuration, this.database.getMigrationSession(), this.migrationInfo, operationResult);
        for (Callback callback : this.callbacks) {
            if (!callback.supports(event, context)) continue;
            callback.handle(event, context);
        }
    }

    private void execute(Event event, Session session) {
        SimpleContext context = new SimpleContext(this.configuration, session, null, null);
        for (Callback callback : this.callbacks) {
            if (!callback.supports(event, context)) continue;
            if (callback.canHandleInTransaction(event, context)) {
                ExecutionTemplateFactory.createExecutionTemplate(session.getJdbcConnection(), this.database).execute(() -> {
                    this.execute(session, callback, event, context);
                    return null;
                });
                continue;
            }
            this.execute(session, callback, event, context);
        }
    }

    private void execute(Session session, Callback callback, Event event, Context context) {
        session.restoreOriginalState();
        session.changeCurrentSchemaTo(this.schema);
        this.handleEvent(callback, event, context);
    }

    private void handleEvent(Callback callback, Event event, Context context) {
        try {
            callback.handle(event, context);
        }
        catch (RuntimeException e) {
            throw new MigrateDbException("Error while executing " + event.getId() + " callback: " + e.getMessage(), e);
        }
    }
}

