/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.pattern;

import java.util.List;
import java.util.Locale;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrationState;

public final class ValidatePattern {
    private final String migrationType;
    private final String migrationState;
    public static final List<String> validMigrationTypes = List.of("*", "repeatable", "versioned");
    public static final List<String> validMigrationStates = List.of("*", MigrationState.MISSING_SUCCESS.getDisplayName().toLowerCase(Locale.ROOT), MigrationState.PENDING.getDisplayName().toLowerCase(Locale.ROOT), MigrationState.IGNORED.getDisplayName().toLowerCase(Locale.ROOT), MigrationState.FUTURE_SUCCESS.getDisplayName().toLowerCase(Locale.ROOT));

    private ValidatePattern(String migrationType, String migrationState) {
        this.migrationType = migrationType;
        this.migrationState = migrationState;
    }

    public String pattern() {
        return this.migrationType + ":" + this.migrationState;
    }

    public String toString() {
        return this.pattern();
    }

    public static ValidatePattern fromPattern(String pattern) {
        String[] patternParts = pattern.split(":");
        if (patternParts.length != 2) {
            throw new MigrateDbException("Invalid pattern '" + pattern + "'. Pattern must be of the form <migration_type>:<migration_state>");
        }
        String migrationType = patternParts[0].trim().toLowerCase(Locale.ROOT);
        String migrationState = patternParts[1].trim().toLowerCase(Locale.ROOT);
        if (!validMigrationTypes.contains(migrationType)) {
            throw new MigrateDbException("Invalid migration type '" + patternParts[0] + "'. Valid types are: " + validMigrationTypes);
        }
        if (!validMigrationStates.contains(migrationState)) {
            throw new MigrateDbException("Invalid migration state '" + patternParts[1] + "'. Valid states are: " + validMigrationStates);
        }
        return new ValidatePattern(migrationType, migrationState);
    }

    public boolean matchesMigration(boolean isVersioned, MigrationState state) {
        if (!state.getDisplayName().equalsIgnoreCase(this.migrationState) && !this.migrationState.equals("*")) {
            return false;
        }
        if (this.migrationType.equals("*")) {
            return true;
        }
        if (isVersioned && this.migrationType.equalsIgnoreCase("versioned")) {
            return true;
        }
        return !isVersioned && this.migrationType.equalsIgnoreCase("repeatable");
    }
}

