/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.logging;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import migratedb.v1.core.api.logging.LogSystem;
import migratedb.v1.core.internal.logging.ApacheCommonsLogSystem;
import migratedb.v1.core.internal.logging.JavaUtilLogSystem;
import migratedb.v1.core.internal.logging.MultiLogSystem;
import migratedb.v1.core.internal.logging.NoLogSystem;
import migratedb.v1.core.internal.logging.Slf4jLogSystem;
import migratedb.v1.core.internal.util.ClassUtils;
import migratedb.v1.core.internal.util.FeatureDetector;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LogSystems {
    public static final String APACHE_COMMONS = "apache-commons";
    public static final String AUTO_DETECT = "auto";
    public static final String JAVA_UTIL = "jul";
    public static final String SLF4J = "slf4j";
    public static final String CONSOLE = "console";
    public static final String NONE = "none";

    public static LogSystem fromStrings(Set<String> logSystemNames, ClassLoader classLoader, @Nullable LogSystem fallback) {
        LinkedHashSet<LogSystem> logSystems = new LinkedHashSet<LogSystem>();
        block20: for (String logSystemName : logSystemNames) {
            switch (logSystemName.toLowerCase(Locale.ROOT)) {
                case "apache-commons": {
                    logSystems.add(ApacheCommonsLogSystem.INSTANCE);
                    continue block20;
                }
                case "auto": {
                    logSystems.add(LogSystems.autoDetect(classLoader, fallback));
                    continue block20;
                }
                case "jul": {
                    logSystems.add(JavaUtilLogSystem.INSTANCE);
                    continue block20;
                }
                case "none": {
                    continue block20;
                }
                case "slf4j": {
                    logSystems.add(Slf4jLogSystem.INSTANCE);
                    continue block20;
                }
                case "console": {
                    if (fallback == null) continue block20;
                    logSystems.add(fallback);
                    continue block20;
                }
            }
            logSystems.add(LogSystems.custom(logSystemName, classLoader));
        }
        switch (logSystems.size()) {
            case 0: {
                return NoLogSystem.INSTANCE;
            }
            case 1: {
                return (LogSystem)logSystems.iterator().next();
            }
        }
        return new MultiLogSystem(logSystems);
    }

    public static LogSystem custom(String className, ClassLoader classLoader) {
        return (LogSystem)ClassUtils.instantiate(className, classLoader);
    }

    public static LogSystem autoDetect(ClassLoader classLoader, @Nullable LogSystem fallback) {
        FeatureDetector featureDetector = new FeatureDetector(classLoader);
        if (featureDetector.isSlf4jAvailable()) {
            return Slf4jLogSystem.INSTANCE;
        }
        if (featureDetector.isApacheCommonsLoggingAvailable()) {
            return ApacheCommonsLogSystem.INSTANCE;
        }
        if (fallback == null) {
            return JavaUtilLogSystem.INSTANCE;
        }
        return fallback;
    }
}

