/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.logging;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import migratedb.v1.core.api.logging.LogSystem;
import migratedb.v1.core.api.logging.LogSystems;
import migratedb.v1.core.internal.util.ClassUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Log {
    private static volatile LogSystem defaultLogSystem = LogSystems.autoDetect(ClassUtils.defaultClassLoader(), null);
    private static final List<Map.Entry<Thread, LogSystem>> overrides = new CopyOnWriteArrayList<Map.Entry<Thread, LogSystem>>();
    private final String logName;

    public static void setDefaultLogSystem(LogSystem defaultLogSystem) {
        Log.defaultLogSystem = defaultLogSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withLogSystem(LogSystem newLogSystem, Supplier<T> action) {
        Map.Entry<Thread, LogSystem> override = Map.entry(Thread.currentThread(), newLogSystem);
        try {
            overrides.add(override);
            T t = action.get();
            return t;
        }
        finally {
            overrides.removeIf(it -> it == override);
        }
    }

    private LogSystem getLogSystemForCurrentThread() {
        Thread currentThread = Thread.currentThread();
        for (Map.Entry<Thread, LogSystem> override : overrides) {
            if (override.getKey() != currentThread) continue;
            return override.getValue();
        }
        return defaultLogSystem;
    }

    public static Log getLog(Class<?> klass) {
        return new Log(klass.getName());
    }

    private Log(String logName) {
        this.logName = logName;
    }

    public boolean isDebugEnabled() {
        return this.getLogSystemForCurrentThread().isDebugEnabled(this.logName);
    }

    public void debug(@Nullable String message) {
        this.getLogSystemForCurrentThread().debug(this.logName, String.valueOf(message));
    }

    public void info(@Nullable String message) {
        this.getLogSystemForCurrentThread().info(this.logName, String.valueOf(message));
    }

    public void warn(@Nullable String message) {
        this.getLogSystemForCurrentThread().warn(this.logName, String.valueOf(message));
    }

    public void error(@Nullable String message) {
        this.getLogSystemForCurrentThread().error(this.logName, String.valueOf(message));
    }

    public void error(@Nullable String message, @Nullable Exception e) {
        if (e == null) {
            this.getLogSystemForCurrentThread().error(this.logName, String.valueOf(message));
        } else {
            this.getLogSystemForCurrentThread().error(this.logName, String.valueOf(message), e);
        }
    }
}

