/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.internal.schemahistory;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Objects;
import migratedb.v1.core.api.Checksum;
import migratedb.v1.core.api.MigrationType;
import migratedb.v1.core.api.Version;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AppliedMigration {
    private final int installedRank;
    private final @Nullable Version version;
    private final String description;
    private final MigrationType type;
    private final String script;
    private final @Nullable Checksum checksum;
    private final Instant installedOn;
    private final String installedBy;
    private final int executionTime;
    private final boolean success;

    public AppliedMigration(int installedRank, @Nullable Version version, String description, MigrationType type, String script, @Nullable Checksum checksum, Timestamp installedOn, String installedBy, int executionTime, boolean success) {
        this.installedRank = installedRank;
        this.version = version;
        this.description = description;
        this.type = type;
        this.script = script;
        this.checksum = checksum;
        this.installedOn = installedOn == null ? null : installedOn.toInstant();
        this.installedBy = installedBy;
        this.executionTime = executionTime;
        this.success = success;
    }

    public int getInstalledRank() {
        return this.installedRank;
    }

    public @Nullable Version getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public MigrationType getType() {
        return this.type;
    }

    public String getScript() {
        return this.script;
    }

    public @Nullable Checksum getChecksum() {
        return this.checksum;
    }

    public Instant getInstalledOn() {
        return this.installedOn;
    }

    public String getInstalledBy() {
        return this.installedBy;
    }

    public int getExecutionTime() {
        return this.executionTime;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AppliedMigration)) {
            return false;
        }
        AppliedMigration other = (AppliedMigration)o;
        return this.executionTime == other.executionTime && this.installedRank == other.installedRank && this.success == other.success && Objects.equals(this.checksum, other.checksum) && Objects.equals(this.description, other.description) && Objects.equals(this.installedBy, other.installedBy) && Objects.equals(this.installedOn, other.installedOn) && Objects.equals(this.script, other.script) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.version, other.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.installedRank, this.version, this.description, this.type, this.script, this.checksum, this.installedOn, this.installedBy, this.executionTime, this.success});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{installedRank=" + this.installedRank + ", version=" + this.version + ", description='" + this.description + "', type=" + this.type + ", checksum=" + this.checksum + ", installedOn=" + this.installedOn + ", installedBy='" + this.installedBy + "', success=" + this.success + "}";
    }

    public boolean isExecutionOfRepeatableMigration() {
        return this.getVersion() == null && !this.getType().equals((Object)MigrationType.BASELINE) && !this.getType().equals((Object)MigrationType.SCHEMA);
    }
}

