/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.internal.database.base;

import java.io.Closeable;
import java.sql.DatabaseMetaData;
import java.util.List;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.internal.database.base.DatabaseType;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.database.base.Session;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.sqlscript.Delimiter;
import migratedb.v1.core.api.internal.sqlscript.SqlScript;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;

public interface Database
extends Closeable {
    public void ensureSupported();

    public Version getVersion();

    public Delimiter getDefaultDelimiter();

    public String getCatalog();

    public String getCurrentUser();

    public boolean supportsDdlTransactions();

    public boolean supportsChangingCurrentSchema();

    public String getBooleanTrue();

    public String getBooleanFalse();

    public String quote(String ... var1);

    public boolean catalogIsSchema();

    public String unQuote(String var1);

    public boolean usesSingleSession();

    public DatabaseMetaData getJdbcMetaData();

    public Session getMainSession();

    public Session getMigrationSession();

    public SqlScript getCreateScript(SqlScriptFactory var1, Table var2, boolean var3);

    public String getRawCreateScript(Table var1, boolean var2);

    public String getInsertStatement(Table var1);

    public String getBaselineStatement(Table var1);

    public String getSelectStatement(Table var1);

    public String getInstalledBy();

    public DatabaseType getDatabaseType();

    public boolean supportsEmptyMigrationDescription();

    public boolean supportsMultiStatementTransactions();

    public List<? extends Schema> getAllSchemas();

    @Override
    public void close();
}

