/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import migratedb.v1.core.api.MigrateDbException;

public final class Version
implements Comparable<Version> {
    private static final Pattern SPLIT_REGEX = Pattern.compile("\\.(?=\\d)");
    private final List<BigInteger> versionParts;
    private final String displayText;

    public static Version parse(String version) {
        return new Version(version);
    }

    private Version(String version) {
        String normalizedVersion = version.replace('_', '.');
        this.versionParts = this.tokenize(normalizedVersion);
        this.displayText = normalizedVersion;
    }

    public String toString() {
        return this.displayText;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)o) == 0;
    }

    public int hashCode() {
        return this.versionParts == null ? 0 : this.versionParts.hashCode();
    }

    public boolean isAtLeast(String otherVersion) {
        return this.compareTo(new Version(otherVersion)) >= 0;
    }

    public boolean isNewerThan(String otherVersion) {
        return this.compareTo(new Version(otherVersion)) > 0;
    }

    public boolean isMajorNewerThan(String otherVersion) {
        return this.getMajor().compareTo(new Version(otherVersion).getMajor()) > 0;
    }

    public BigInteger getMajor() {
        return this.versionParts.get(0);
    }

    public String getMajorAsString() {
        return Objects.toString(this.versionParts.get(0), null);
    }

    public String getMinorAsString() {
        if (this.versionParts.size() == 1) {
            return "0";
        }
        return Objects.toString(this.versionParts.get(1), null);
    }

    @Override
    public int compareTo(Version o) {
        if (this == o) {
            return 0;
        }
        List<BigInteger> parts1 = this.versionParts;
        List<BigInteger> parts2 = o.versionParts;
        int largestNumberOfParts = Math.max(parts1.size(), parts2.size());
        for (int i = 0; i < largestNumberOfParts; ++i) {
            int compared = this.getOrZero(parts1, i).compareTo(this.getOrZero(parts2, i));
            if (compared == 0) continue;
            return compared;
        }
        return 0;
    }

    private BigInteger getOrZero(List<BigInteger> elements, int i) {
        return i < elements.size() ? elements.get(i) : BigInteger.ZERO;
    }

    private List<BigInteger> tokenize(String versionStr) {
        ArrayList<BigInteger> parts = new ArrayList<BigInteger>();
        for (String part : SPLIT_REGEX.split(versionStr)) {
            parts.add(this.toBigInteger(versionStr, part));
        }
        for (int i = parts.size() - 1; i > 0 && ((BigInteger)parts.get(i)).equals(BigInteger.ZERO); --i) {
            parts.remove(i);
        }
        return parts;
    }

    private BigInteger toBigInteger(String versionStr, String part) {
        try {
            return new BigInteger(part);
        }
        catch (NumberFormatException e) {
            String invalidValue = versionStr.length() > 20 ? versionStr.substring(0, 17) + "..." : versionStr;
            throw new MigrateDbException("Version may only contain 0..9 and . (dot). Invalid version: " + invalidValue);
        }
    }
}

