/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.Version;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TargetVersion {
    public static final TargetVersion LATEST = new TargetVersion("<< Latest Version >>");
    public static final TargetVersion CURRENT = new TargetVersion("<< Current Version >>");
    public static final TargetVersion NEXT = new TargetVersion("<< Next Version >>");
    private final @Nullable Version version;
    private final String displayText;

    public static TargetVersion of(Version version) {
        return new TargetVersion(version);
    }

    public static TargetVersion parse(String s) {
        if ("current".equalsIgnoreCase(s)) {
            return CURRENT;
        }
        if ("next".equalsIgnoreCase(s)) {
            return NEXT;
        }
        if ("latest".equalsIgnoreCase(s)) {
            return LATEST;
        }
        return new TargetVersion(Version.parse(s));
    }

    private TargetVersion(Version version) {
        this.displayText = version.toString();
        this.version = version;
    }

    private TargetVersion(String displayText) {
        this.displayText = displayText;
        this.version = null;
    }

    public final String getDisplayText() {
        return this.displayText;
    }

    public OrElseDoStep withVersion(Consumer<Version> action) {
        if (this.version != null) {
            action.accept(this.version);
        }
        return new OrElseDoStep();
    }

    public <T> OrElseGetStep<T> mapVersion(Function<? super Version, ? extends T> mapper) {
        return new OrElseGetStep<T>(mapper);
    }

    public String toString() {
        return this.displayText;
    }

    public class OrElseDoStep {
        public void orElseDo(Map<TargetVersion, Runnable> actions) {
            Runnable action;
            if (TargetVersion.this.version == null && (action = actions.get(TargetVersion.this)) != null) {
                action.run();
            }
        }

        public void orElseDoNothing() {
        }
    }

    public class OrElseGetStep<T> {
        private final Function<? super Version, ? extends T> mapper;

        public OrElseGetStep(Function<? super Version, ? extends T> mapper) {
            this.mapper = mapper;
        }

        public Optional<T> orElseGet(Map<TargetVersion, ? extends Supplier<Optional<T>>> symbolMappers) {
            if (TargetVersion.this.version == null) {
                Supplier<Optional<T>> symbolMapper = symbolMappers.get(TargetVersion.this);
                if (symbolMapper == null) {
                    throw new MigrateDbException("No mapped value defined for case " + this);
                }
                return symbolMapper.get();
            }
            return Optional.ofNullable(this.mapper.apply(TargetVersion.this.version));
        }
    }
}

