/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api;

import java.util.List;
import java.util.Objects;
import migratedb.v1.core.api.Version;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MigrationPattern {
    private final String migrationName;

    public MigrationPattern(String migrationName) {
        this.migrationName = migrationName;
    }

    public static boolean anyMatchOrEmpty(Version version, @Nullable List<MigrationPattern> patterns) {
        return patterns == null || patterns.isEmpty() || patterns.stream().anyMatch(it -> it.matches(version, null));
    }

    public static boolean anyMatchOrEmpty(String description, @Nullable List<MigrationPattern> patterns) {
        return patterns == null || patterns.isEmpty() || patterns.stream().anyMatch(it -> it.matches(null, description));
    }

    public boolean matches(@Nullable Version version, @Nullable String description) {
        if (version != null) {
            String pattern = this.migrationName.replace("_", ".");
            return pattern.equals(version.toString());
        }
        String pattern = this.migrationName.replace("_", " ");
        return pattern.equals(description);
    }

    public String toString() {
        return this.migrationName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MigrationPattern)) {
            return false;
        }
        MigrationPattern other = (MigrationPattern)obj;
        return Objects.equals(this.migrationName, other.migrationName);
    }

    public int hashCode() {
        return this.migrationName.hashCode();
    }
}

