/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core;

import java.util.ArrayList;
import java.util.stream.Collectors;
import migratedb.v1.core.MigrateDbExecutor;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrateDbValidateException;
import migratedb.v1.core.api.MigrationInfoService;
import migratedb.v1.core.api.callback.Event;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.configuration.DefaultConfiguration;
import migratedb.v1.core.api.configuration.FluentConfiguration;
import migratedb.v1.core.api.internal.callback.CallbackExecutor;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.api.output.BaselineResult;
import migratedb.v1.core.api.output.LiberateResult;
import migratedb.v1.core.api.output.MigrateResult;
import migratedb.v1.core.api.output.RepairResult;
import migratedb.v1.core.api.output.ValidateResult;
import migratedb.v1.core.api.resolver.MigrationResolver;
import migratedb.v1.core.internal.command.DbBaseline;
import migratedb.v1.core.internal.command.DbInfo;
import migratedb.v1.core.internal.command.DbLiberate;
import migratedb.v1.core.internal.command.DbMigrate;
import migratedb.v1.core.internal.command.DbRepair;
import migratedb.v1.core.internal.command.DbSchemas;
import migratedb.v1.core.internal.command.DbValidate;
import migratedb.v1.core.internal.schemahistory.SchemaHistory;

public class MigrateDb {
    private static final Log LOG = Log.getLog(MigrateDb.class);
    private final DefaultConfiguration configuration;
    private final MigrateDbExecutor executor;

    public static FluentConfiguration configure() {
        return new FluentConfiguration();
    }

    public static FluentConfiguration configure(ClassLoader classLoader) {
        return new FluentConfiguration(classLoader);
    }

    public MigrateDb(Configuration configuration) {
        this.configuration = new DefaultConfiguration(configuration);
        this.executor = new MigrateDbExecutor(configuration);
    }

    public Configuration getConfiguration() {
        return new DefaultConfiguration(this.configuration);
    }

    public LiberateResult liberate() {
        return this.executor.execute(context -> {
            LiberateResult liberateResult = new DbLiberate(context.schemaHistory, this.configuration, context.database, context.defaultSchema, context.schemas, context.callbackExecutor, true).liberate();
            context.callbackExecutor.onOperationFinishEvent(Event.AFTER_LIBERATE_OPERATION_FINISH, liberateResult);
            return liberateResult;
        }, false);
    }

    public MigrateResult migrate() {
        return this.executor.execute(context -> {
            LiberateResult liberateResult = null;
            if (this.configuration.isLiberateOnMigrate() && !context.schemaHistory.exists() && context.defaultSchema.getTable(this.configuration.getOldTable()).exists()) {
                LOG.info("Executing liberate command because " + context.schemaHistory.getTable() + " is missing , but table" + this.configuration.getOldTable() + " exists");
                liberateResult = new DbLiberate(context.schemaHistory, this.configuration, context.database, context.defaultSchema, new Schema[0], context.callbackExecutor, false).liberate();
            }
            if (this.configuration.isValidateOnMigrate()) {
                ValidateResult validateResult = this.doValidate(context.database, context.migrationResolver, context.schemaHistory, context.defaultSchema, context.callbackExecutor, true);
                if (!validateResult.validationSuccessful) {
                    throw new MigrateDbValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
                }
            }
            if (!context.schemaHistory.exists()) {
                ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                for (Schema schema : context.schemas) {
                    if (!schema.exists() || schema.isEmpty()) continue;
                    nonEmptySchemas.add(schema);
                }
                if (!nonEmptySchemas.isEmpty() && !this.configuration.isSkipExecutingMigrations()) {
                    if (this.configuration.isBaselineOnMigrate()) {
                        this.doBaseline(context.schemaHistory, context.callbackExecutor, context.database);
                    } else if (!context.schemaHistory.exists()) {
                        throw new MigrateDbException("Found non-empty schema(s) " + nonEmptySchemas.stream().map(Object::toString).collect(Collectors.joining(",")) + " but no schema history table. Use baseline() or set baselineOnMigrate to true to initialize the schema history table.");
                    }
                } else {
                    if (this.configuration.isCreateSchemas()) {
                        new DbSchemas(context.database, context.schemas, context.schemaHistory, context.callbackExecutor).create(false);
                    } else if (!context.defaultSchema.exists()) {
                        LOG.warn("The configuration option 'createSchemas' is false.\nHowever, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://daniel-huss.github.io/migratedb/about/create-schemas");
                    }
                    context.schemaHistory.create(false);
                }
            }
            MigrateResult result = new DbMigrate(context.database, context.schemaHistory, context.defaultSchema, context.migrationResolver, this.configuration, context.callbackExecutor).migrate();
            result.liberateResult = liberateResult;
            context.callbackExecutor.onOperationFinishEvent(Event.AFTER_MIGRATE_OPERATION_FINISH, result);
            return result;
        }, true);
    }

    public MigrationInfoService info() {
        return this.executor.execute(context -> {
            MigrationInfoService migrationInfoService = new DbInfo(context.migrationResolver, context.schemaHistory, this.configuration, context.database, context.callbackExecutor, context.schemas).info();
            context.callbackExecutor.onOperationFinishEvent(Event.AFTER_INFO_OPERATION_FINISH, migrationInfoService.getInfoResult());
            return migrationInfoService;
        }, true);
    }

    public void validate() throws MigrateDbException {
        this.executor.execute(context -> {
            ValidateResult validateResult = this.doValidate(context.database, context.migrationResolver, context.schemaHistory, context.defaultSchema, context.callbackExecutor, this.configuration.isIgnorePendingMigrations());
            context.callbackExecutor.onOperationFinishEvent(Event.AFTER_VALIDATE_OPERATION_FINISH, validateResult);
            if (!validateResult.validationSuccessful) {
                throw new MigrateDbValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
            }
            return null;
        }, true);
    }

    public ValidateResult validateWithResult() throws MigrateDbException {
        return this.executor.execute(context -> {
            ValidateResult validateResult = this.doValidate(context.database, context.migrationResolver, context.schemaHistory, context.defaultSchema, context.callbackExecutor, this.configuration.isIgnorePendingMigrations());
            context.callbackExecutor.onOperationFinishEvent(Event.AFTER_VALIDATE_OPERATION_FINISH, validateResult);
            return validateResult;
        }, true);
    }

    public BaselineResult baseline() throws MigrateDbException {
        return this.executor.execute(context -> {
            if (this.configuration.isCreateSchemas()) {
                new DbSchemas(context.database, context.schemas, context.schemaHistory, context.callbackExecutor).create(true);
            } else {
                LOG.warn("The configuration option 'createSchemas' is false.\nEven though MigrateDb is configured not to create any schemas, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://daniel-huss.github.io/migratedb/about/create-schemas");
            }
            BaselineResult baselineResult = this.doBaseline(context.schemaHistory, context.callbackExecutor, context.database);
            context.callbackExecutor.onOperationFinishEvent(Event.AFTER_BASELINE_OPERATION_FINISH, baselineResult);
            return baselineResult;
        }, false);
    }

    public RepairResult repair() throws MigrateDbException {
        return this.executor.execute(context -> {
            RepairResult repairResult = new DbRepair(context.database, context.migrationResolver, context.schemaHistory, context.callbackExecutor, this.configuration).repair();
            context.callbackExecutor.onOperationFinishEvent(Event.AFTER_REPAIR_OPERATION_FINISH, repairResult);
            return repairResult;
        }, true);
    }

    private ValidateResult doValidate(Database database, MigrationResolver migrationResolver, SchemaHistory schemaHistory, Schema defaultSchema, CallbackExecutor callbackExecutor, boolean ignorePending) {
        return new DbValidate(database, schemaHistory, defaultSchema, migrationResolver, this.configuration, ignorePending, callbackExecutor).validate();
    }

    private BaselineResult doBaseline(SchemaHistory schemaHistory, CallbackExecutor callbackExecutor, Database database) {
        return new DbBaseline(schemaHistory, this.configuration.getBaselineVersion(), this.configuration.getBaselineDescription(), callbackExecutor, database).baseline();
    }
}

