/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.util;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import migratedb.v1.core.api.Location;
import migratedb.v1.core.api.logging.Log;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Locations {
    private static final Log LOG = Log.getLog(Locations.class);
    private final List<Location> locations;

    public Locations(List<Location> rawLocations) {
        this.locations = Locations.processLocations(rawLocations);
    }

    public Locations(List<String> rawLocations, @Nullable ClassLoader classLoader) {
        this.locations = Locations.processLocations(rawLocations.stream().map(it -> Location.parse(it, classLoader)).collect(Collectors.toUnmodifiableList()));
    }

    private static List<Location> processLocations(List<Location> locations) {
        LinkedHashSet<Location> processed = new LinkedHashSet<Location>(locations.size());
        for (Location location : locations) {
            Location parentLocation;
            if (processed.contains(location)) {
                LOG.warn("Discarding duplicate location '" + location + "'");
                continue;
            }
            if (location instanceof Location.FileSystemLocation && (parentLocation = Locations.getParentLocationIfExists((Location.FileSystemLocation)location, processed)) != null) {
                LOG.warn("Discarding location '" + location + "' as it is a sub-location of '" + parentLocation + "'");
                continue;
            }
            processed.add(location);
        }
        return processed.stream().collect(Collectors.toUnmodifiableList());
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    private static @Nullable Location getParentLocationIfExists(Location.FileSystemLocation location, Collection<Location> otherLocations) {
        for (Location otherLocation : otherLocations) {
            if (!(otherLocation instanceof Location.FileSystemLocation) || !Locations.isParent((Location.FileSystemLocation)otherLocation, location)) continue;
            return otherLocation;
        }
        return null;
    }

    private static boolean isParent(Location.FileSystemLocation maybeParent, Location.FileSystemLocation maybeChild) {
        Path childDir;
        Path parentDir = maybeParent.getBaseDirectory();
        if (parentDir.equals(childDir = maybeChild.getBaseDirectory()) || childDir.getNameCount() < parentDir.getNameCount()) {
            return false;
        }
        do {
            if (!parentDir.equals(childDir = childDir.getParent())) continue;
            return true;
        } while (childDir != null && !childDir.equals(childDir.getParent()));
        return false;
    }
}

