/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.util;

import migratedb.v1.core.internal.util.ClassUtils;

public final class FeatureDetector {
    private final ClassLoader classLoader;
    private Boolean apacheCommonsLoggingAvailable;
    private Boolean slf4jAvailable;

    public FeatureDetector(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isApacheCommonsLoggingAvailable() {
        if (this.apacheCommonsLoggingAvailable == null) {
            this.apacheCommonsLoggingAvailable = ClassUtils.isPresent("org.apache.commons.logging.Log", this.classLoader);
        }
        return this.apacheCommonsLoggingAvailable;
    }

    public boolean isSlf4jAvailable() {
        if (this.slf4jAvailable == null) {
            this.slf4jAvailable = ClassUtils.isPresent("org.slf4j.Logger", this.classLoader) && ClassUtils.isPresent("org.slf4j.impl.StaticLoggerBinder", this.classLoader);
            this.slf4jAvailable = this.slf4jAvailable | ClassUtils.isImplementationPresent("org.slf4j.spi.SLF4JServiceProvider", this.classLoader);
        }
        return this.slf4jAvailable;
    }
}

