/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.internal.util.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ClassUtils {
    public static <T> T instantiate(String className, @Nullable ClassLoader classLoader) {
        try {
            return (T)Class.forName(className, true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && (cause = e.getCause()) instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new MigrateDbException("Unable to instantiate class " + className + " : " + e.getMessage(), e);
        }
    }

    public static <T> List<T> instantiateAll(Collection<String> classes, ClassLoader classLoader) {
        ArrayList<T> clazzes = new ArrayList<T>();
        for (String clazz : classes) {
            if (!StringUtils.hasLength(clazz)) continue;
            clazzes.add(ClassUtils.instantiate(clazz, classLoader));
        }
        return clazzes;
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (LinkageError | ReflectiveOperationException ignored) {
            return false;
        }
    }

    public static boolean isImplementationPresent(String serviceName, ClassLoader classLoader) {
        try {
            Class<?> service = classLoader.loadClass(serviceName);
            return ServiceLoader.load(service).iterator().hasNext();
        }
        catch (LinkageError | ReflectiveOperationException | ServiceConfigurationError ignored) {
            return false;
        }
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new MigrateDbException("Cannot load class " + className, e);
        }
    }

    public static Path guessLocationOnDisk(Class<?> aClass) {
        ProtectionDomain protectionDomain = aClass.getProtectionDomain();
        if (protectionDomain == null) {
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL location = codeSource.getLocation();
        if (location == null) {
            return null;
        }
        try {
            String[] packagePath = StringUtils.tokenizeToStringArray(aClass.getName(), ".");
            Path path = Paths.get(location.toURI()).toAbsolutePath();
            for (String packagePart : packagePath) {
                path = path.resolve(packagePart);
            }
            return path.resolveSibling(path.getFileName() + ".class");
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static ClassLoader defaultClassLoader() {
        ClassLoader result = Thread.currentThread().getContextClassLoader();
        if (result == null) {
            result = ClassUtils.class.getClassLoader();
        }
        if (result == null) {
            result = ClassLoader.getSystemClassLoader();
        }
        assert (result != null);
        return result;
    }
}

