/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.strategy;

import java.sql.SQLException;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.util.SqlCallable;

public class RetryStrategy {
    private final boolean unlimitedRetries;
    private int numberOfRetriesRemaining;

    public RetryStrategy(int numberOfRetries) {
        this.unlimitedRetries = numberOfRetries < 0;
        this.numberOfRetriesRemaining = numberOfRetries;
    }

    private boolean hasMoreRetries() {
        return this.unlimitedRetries || this.numberOfRetriesRemaining > 0;
    }

    private void nextRetry() {
        if (!this.unlimitedRetries) {
            --this.numberOfRetriesRemaining;
        }
    }

    private int nextWaitInMilliseconds() {
        return 1000;
    }

    public void doWithRetries(SqlCallable<Boolean> callable, String interruptionMessage, String retriesExceededMessage) throws SQLException {
        while (!callable.call().booleanValue()) {
            try {
                Thread.sleep(this.nextWaitInMilliseconds());
            }
            catch (InterruptedException e) {
                throw new MigrateDbException(interruptionMessage, e);
            }
            if (!this.hasMoreRetries()) {
                throw new MigrateDbException(retriesExceededMessage);
            }
            this.nextRetry();
        }
    }
}

