/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.sqlscript;

import migratedb.v1.core.api.callback.Event;
import migratedb.v1.core.api.callback.Warning;
import migratedb.v1.core.api.internal.callback.CallbackExecutor;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.internal.jdbc.Result;
import migratedb.v1.core.api.internal.jdbc.Results;
import migratedb.v1.core.api.internal.sqlscript.SqlScript;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutor;
import migratedb.v1.core.api.internal.sqlscript.SqlStatement;
import migratedb.v1.core.api.internal.sqlscript.SqlStatementIterator;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.sqlscript.MigrateDbSqlScriptException;
import migratedb.v1.core.internal.util.AsciiTable;

public class DefaultSqlScriptExecutor
implements SqlScriptExecutor {
    private static final Log LOG = Log.getLog(DefaultSqlScriptExecutor.class);
    protected final JdbcTemplate jdbcTemplate;
    private final CallbackExecutor callbackExecutor;
    private final boolean outputQueryResults;

    public DefaultSqlScriptExecutor(JdbcTemplate jdbcTemplate, CallbackExecutor callbackExecutor, boolean outputQueryResults) {
        this.jdbcTemplate = jdbcTemplate;
        this.callbackExecutor = callbackExecutor;
        this.outputQueryResults = outputQueryResults;
    }

    @Override
    public void execute(SqlScript sqlScript) {
        try (SqlStatementIterator sqlStatementIterator = sqlScript.getSqlStatements();){
            while (sqlStatementIterator.hasNext()) {
                SqlStatement sqlStatement = (SqlStatement)sqlStatementIterator.next();
                this.executeStatement(this.jdbcTemplate, sqlScript, sqlStatement);
            }
        }
    }

    protected void logStatementExecution(SqlStatement sqlStatement) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing SQL: " + sqlStatement.getSql());
        }
    }

    protected void executeStatement(JdbcTemplate jdbcTemplate, SqlScript sqlScript, SqlStatement sqlStatement) {
        this.logStatementExecution(sqlStatement);
        this.callbackExecutor.onEachMigrateEvent(Event.BEFORE_EACH_MIGRATE_STATEMENT);
        Results results = sqlStatement.execute(jdbcTemplate);
        this.callbackExecutor.onEachMigrateEvent(Event.AFTER_EACH_MIGRATE_STATEMENT);
        if (results.getException() != null) {
            this.callbackExecutor.onEachMigrateEvent(Event.AFTER_EACH_MIGRATE_STATEMENT_ERROR);
            this.printWarnings(results);
            this.handleException(results, sqlScript, sqlStatement);
            return;
        }
        this.printWarnings(results);
        this.handleResults(results);
    }

    protected void handleResults(Results results) {
        for (Result result : results.getResults()) {
            long updateCount = result.getUpdateCount();
            if (updateCount != -1L) {
                this.handleUpdateCount(updateCount);
            }
            this.outputQueryResult(result);
        }
    }

    protected void outputQueryResult(Result result) {
        if (this.outputQueryResults && result.getColumns() != null && !result.getColumns().isEmpty()) {
            StringBuilder output = new StringBuilder("\n");
            new AsciiTable(result.getColumns(), result.getData(), true, "", "No rows returned").render(output);
            LOG.info(output.toString());
        }
    }

    private void handleUpdateCount(long updateCount) {
        LOG.debug(updateCount + (updateCount == 1L ? " row" : " rows") + " affected");
    }

    protected void handleException(Results results, SqlScript sqlScript, SqlStatement sqlStatement) {
        throw new MigrateDbSqlScriptException(sqlScript.getResource(), sqlStatement, results.getException());
    }

    private void printWarnings(Results results) {
        for (Warning warning : results.getWarnings()) {
            if ("00000".equals(warning.getState())) {
                LOG.info("DB: " + warning.getMessage());
                continue;
            }
            LOG.warn("DB: " + warning.getMessage() + " (SQL State: " + warning.getState() + " - Error Code: " + warning.getCode() + ")");
        }
    }
}

