/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.schemahistory;

import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.schemahistory.JdbcTableSchemaHistory;
import migratedb.v1.core.internal.schemahistory.SchemaHistory;

public final class SchemaHistoryFactory {
    private static final Log LOG = Log.getLog(SchemaHistoryFactory.class);

    public static SchemaHistory getSchemaHistory(Configuration configuration, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Database database, Schema schema) {
        Table table = schema.getTable(configuration.getTable());
        return new JdbcTableSchemaHistory(sqlScriptExecutorFactory, sqlScriptFactory, database, table);
    }

    public static SchemasWithDefault scanSchemas(Configuration configuration, Database database) {
        Schema defaultSchema;
        List<String> schemaNames = configuration.getSchemas();
        String defaultSchemaName = configuration.getDefaultSchema();
        LOG.debug("Schemas: " + String.join((CharSequence)",", schemaNames));
        LOG.debug("Default schema: " + defaultSchemaName);
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (String schemaName : schemaNames) {
            schemas.add(database.getMainSession().getSchema(schemaName));
        }
        if (defaultSchemaName == null) {
            if (schemaNames.isEmpty()) {
                Schema currentSchema = database.getMainSession().getCurrentSchema();
                if (currentSchema == null || currentSchema.getName() == null) {
                    throw new MigrateDbException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the 'defaultSchema' property");
                }
                defaultSchemaName = currentSchema.getName();
            } else {
                defaultSchemaName = schemaNames.get(0);
            }
        }
        if (!schemas.contains(defaultSchema = database.getMainSession().getSchema(defaultSchemaName))) {
            schemas.add(0, defaultSchema);
        }
        return new SchemasWithDefault(schemas, defaultSchema);
    }

    public static final class SchemasWithDefault {
        public final List<Schema> all;
        public final Schema defaultSchema;

        public SchemasWithDefault(List<Schema> schemas, Schema defaultSchema) {
            this.all = schemas;
            this.defaultSchema = defaultSchema;
        }
    }
}

