/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.schemahistory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import migratedb.v1.core.api.Checksum;
import migratedb.v1.core.api.MigrationPattern;
import migratedb.v1.core.api.MigrationType;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.schemahistory.AppliedMigration;
import migratedb.v1.core.api.output.RepairResult;
import migratedb.v1.core.api.resolver.ResolvedMigration;
import migratedb.v1.core.internal.util.AbbreviationUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SchemaHistory {
    public static final String EMPTY_SCHEMA_DESCRIPTION = "<< Empty Schema >>";
    public static final String NO_DESCRIPTION_MARKER = "<< no description >>";
    protected Table table;

    public Table getTable() {
        return this.table;
    }

    public abstract <T> T withLock(Callable<T> var1);

    public abstract boolean exists();

    public abstract void create(boolean var1);

    public final boolean hasAppliedMigrations() {
        for (AppliedMigration appliedMigration : this.allAppliedMigrations()) {
            if (appliedMigration.getType().isExclusiveToAppliedMigrations()) continue;
            return true;
        }
        return false;
    }

    public abstract List<AppliedMigration> allAppliedMigrations();

    public final AppliedMigration getBaselineMarker() {
        List<AppliedMigration> appliedMigrations = this.allAppliedMigrations();
        for (int i = 0; i < Math.min(appliedMigrations.size(), 2); ++i) {
            AppliedMigration appliedMigration = appliedMigrations.get(i);
            if (appliedMigration.getType() != MigrationType.BASELINE) continue;
            return appliedMigration;
        }
        return null;
    }

    public abstract boolean removeFailedMigrations(RepairResult var1, List<MigrationPattern> var2);

    public final void addSchemasMarker(Schema[] schemas) {
        this.addAppliedMigration(null, "<< MigrateDB Schema Creation >>", MigrationType.SCHEMA, Arrays.stream(schemas).map(Object::toString).collect(Collectors.joining(",")), null, 0, true);
    }

    public final boolean hasSchemasMarker() {
        List<AppliedMigration> appliedMigrations = this.allAppliedMigrations();
        return !appliedMigrations.isEmpty() && appliedMigrations.get(0).getType() == MigrationType.SCHEMA;
    }

    public List<String> getSchemasCreatedByMigrateDb() {
        if (!this.hasSchemasMarker()) {
            return new ArrayList<String>();
        }
        return Arrays.stream(this.allAppliedMigrations().get(0).getScript().split(",")).map(result -> this.table.getDatabase().unQuote((String)result)).collect(Collectors.toList());
    }

    public abstract void update(AppliedMigration var1, ResolvedMigration var2);

    public abstract void delete(AppliedMigration var1);

    public void clearCache() {
    }

    public final void addAppliedMigration(Version version, String description, MigrationType type, String script, @Nullable Checksum checksum, int executionTime, boolean success) {
        int installedRank = type == MigrationType.SCHEMA ? 0 : this.calculateInstalledRank();
        this.addAppliedMigration(installedRank, version, AbbreviationUtils.abbreviateDescription(description), type, AbbreviationUtils.abbreviateScript(script), checksum, executionTime, success);
    }

    protected int calculateInstalledRank() {
        List<AppliedMigration> appliedMigrations = this.allAppliedMigrations();
        if (appliedMigrations.isEmpty()) {
            return 1;
        }
        return appliedMigrations.get(appliedMigrations.size() - 1).getInstalledRank() + 1;
    }

    public abstract void addAppliedMigration(int var1, Version var2, String var3, MigrationType var4, String var5, @Nullable Checksum var6, int var7, boolean var8);

    public String toString() {
        return this.table.toString();
    }
}

