/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.callback.Event;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.resource.ResourceName;
import migratedb.v1.core.internal.resource.ResourceType;

public class ResourceNameParser {
    private final Configuration configuration;
    private final List<Prefix> prefixes;

    public ResourceNameParser(Configuration configuration) {
        this.configuration = configuration;
        this.prefixes = this.populatePrefixes(configuration);
    }

    public ResourceName parse(String resourceName) {
        return this.parse(resourceName, this.configuration.getSqlMigrationSuffixes());
    }

    public ResourceName parse(String resourceName, Collection<String> suffixes) {
        PrefixAndSuffix suffixResult = this.stripSuffix(resourceName, suffixes);
        Prefix prefix = this.findPrefix(suffixResult.prefix, this.prefixes);
        if (prefix != null) {
            String exampleDescription;
            PrefixAndSuffix prefixResult = this.stripPrefix(suffixResult.prefix, prefix.prefix);
            assert (prefixResult != null);
            String name = prefixResult.suffix;
            PrefixAndSuffix splitName = this.splitAtSeparator(name, this.configuration.getSqlMigrationSeparator());
            boolean isValid = true;
            Object validationMessage = "";
            String string = exampleDescription = "".equals(splitName.suffix) ? "description" : splitName.suffix;
            if (!ResourceType.isVersioned(prefix.resourceType)) {
                if (!"".equals(splitName.prefix)) {
                    isValid = false;
                    validationMessage = "Invalid repeatable migration / callback name format: " + resourceName + " (It cannot contain a version and should look like this: " + prefixResult.prefix + this.configuration.getSqlMigrationSeparator() + exampleDescription + suffixResult.suffix + ")";
                }
            } else if ("".equals(splitName.prefix)) {
                isValid = false;
                validationMessage = "Invalid versioned migration name format: " + resourceName + " (It must contain a version and should look like this: " + prefixResult.prefix + "1.2" + this.configuration.getSqlMigrationSeparator() + exampleDescription + suffixResult.suffix + ")";
            } else {
                try {
                    Version.parse(splitName.prefix);
                }
                catch (RuntimeException e) {
                    isValid = false;
                    validationMessage = "Invalid versioned migration name format: " + resourceName + " (could not recognise version number " + splitName.prefix + ")";
                }
            }
            String description = splitName.suffix.replace("_", " ");
            return new ResourceName(prefixResult.prefix, splitName.prefix, this.configuration.getSqlMigrationSeparator(), description, splitName.suffix, suffixResult.suffix, isValid, (String)validationMessage);
        }
        return ResourceName.invalid("Unrecognised migration name format: " + resourceName);
    }

    private Prefix findPrefix(String nameWithoutSuffix, List<Prefix> prefixes) {
        for (Prefix prefix : prefixes) {
            if (!nameWithoutSuffix.startsWith(prefix.prefix)) continue;
            return prefix;
        }
        return null;
    }

    private PrefixAndSuffix stripSuffix(String name, Collection<String> suffixes) {
        for (String suffix : suffixes) {
            if (!name.endsWith(suffix)) continue;
            return new PrefixAndSuffix(name.substring(0, name.length() - suffix.length()), suffix);
        }
        return new PrefixAndSuffix(name, "");
    }

    private PrefixAndSuffix stripPrefix(String fileName, String prefix) {
        if (fileName.startsWith(prefix)) {
            return new PrefixAndSuffix(prefix, fileName.substring(prefix.length()));
        }
        return null;
    }

    private PrefixAndSuffix splitAtSeparator(String name, String separator) {
        int separatorIndex = name.indexOf(separator);
        if (separatorIndex >= 0) {
            return new PrefixAndSuffix(name.substring(0, separatorIndex), name.substring(separatorIndex + separator.length()));
        }
        return new PrefixAndSuffix(name, "");
    }

    private List<Prefix> populatePrefixes(Configuration configuration) {
        ArrayList<Prefix> prefixes = new ArrayList<Prefix>();
        prefixes.add(new Prefix(configuration.getSqlMigrationPrefix(), ResourceType.MIGRATION));
        prefixes.add(new Prefix(configuration.getRepeatableSqlMigrationPrefix(), ResourceType.REPEATABLE_MIGRATION));
        for (Event event : Event.values()) {
            prefixes.add(new Prefix(event.getId(), ResourceType.CALLBACK));
        }
        Comparator prefixComparator = (p1, p2) -> p2.prefix.length() - p1.prefix.length();
        prefixes.sort(prefixComparator);
        return prefixes;
    }

    private static final class PrefixAndSuffix {
        final String prefix;
        final String suffix;

        private PrefixAndSuffix(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }
    }

    private static final class Prefix {
        final String prefix;
        final ResourceType resourceType;

        private Prefix(String prefix, ResourceType resourceType) {
            this.prefix = prefix;
            this.resourceType = resourceType;
        }
    }
}

