/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resolver.java;

import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.ClassProvider;
import migratedb.v1.core.api.MigrationType;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;
import migratedb.v1.core.api.migration.JavaMigration;
import migratedb.v1.core.api.resolver.Context;
import migratedb.v1.core.api.resolver.MigrationResolver;
import migratedb.v1.core.api.resolver.ResolvedMigration;
import migratedb.v1.core.internal.resolver.ResolvedMigrationComparator;
import migratedb.v1.core.internal.resolver.ResolvedMigrationImpl;
import migratedb.v1.core.internal.resolver.java.JavaMigrationExecutor;
import migratedb.v1.core.internal.util.ClassUtils;

public class JavaMigrationResolver
implements MigrationResolver {
    private final ClassProvider<JavaMigration> classProvider;
    private final SqlScriptFactory sqlScriptFactory;
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;

    public static ResolvedMigration newResolvedJavaMigration(JavaMigration javaMigration, Configuration configuration, SqlScriptFactory sqlScriptFactory, SqlScriptExecutorFactory sqlScriptExecutorFactory) {
        return new ResolvedMigrationImpl(javaMigration.getVersion(), javaMigration.getDescription(), javaMigration.getClass().getName(), javaMigration.getChecksum(configuration), null, javaMigration.isBaselineMigration() ? MigrationType.JDBC_BASELINE : MigrationType.JDBC, String.valueOf(ClassUtils.guessLocationOnDisk(javaMigration.getClass())), new JavaMigrationExecutor(javaMigration, sqlScriptFactory, sqlScriptExecutorFactory));
    }

    public JavaMigrationResolver(ClassProvider<JavaMigration> classProvider, SqlScriptFactory sqlScriptFactory, SqlScriptExecutorFactory sqlScriptExecutorFactory) {
        this.classProvider = classProvider;
        this.sqlScriptFactory = sqlScriptFactory;
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
    }

    public List<ResolvedMigration> resolveMigrations(Context context) {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        for (Class<JavaMigration> clazz : this.classProvider.getClasses()) {
            JavaMigration javaMigration = (JavaMigration)ClassUtils.instantiate(clazz.getName(), context.getConfiguration().getClassLoader());
            migrations.add(JavaMigrationResolver.newResolvedJavaMigration(javaMigration, context.getConfiguration(), this.sqlScriptFactory, this.sqlScriptExecutorFactory));
        }
        migrations.sort(new ResolvedMigrationComparator());
        return migrations;
    }
}

