/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import migratedb.v1.core.api.ClassProvider;
import migratedb.v1.core.api.ErrorCode;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.parser.ParsingContext;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;
import migratedb.v1.core.api.migration.JavaMigration;
import migratedb.v1.core.api.resolver.Context;
import migratedb.v1.core.api.resolver.MigrationResolver;
import migratedb.v1.core.api.resolver.ResolvedMigration;
import migratedb.v1.core.internal.resolver.ResolvedMigrationComparator;
import migratedb.v1.core.internal.resolver.java.FixedJavaMigrationResolver;
import migratedb.v1.core.internal.resolver.java.JavaMigrationResolver;
import migratedb.v1.core.internal.resolver.sql.SqlMigrationResolver;

public class DefaultMigrationResolver
implements MigrationResolver {
    private final Collection<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();
    private List<ResolvedMigration> availableMigrations;

    public DefaultMigrationResolver(ResourceProvider resourceProvider, ClassProvider<JavaMigration> classProvider, Configuration configuration, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, ParsingContext parsingContext, Collection<MigrationResolver> customMigrationResolvers) {
        if (!configuration.isSkipDefaultResolvers()) {
            this.migrationResolvers.add(new SqlMigrationResolver(resourceProvider, sqlScriptExecutorFactory, sqlScriptFactory, configuration, parsingContext));
            this.migrationResolvers.add(new JavaMigrationResolver(classProvider, sqlScriptFactory, sqlScriptExecutorFactory));
        }
        this.migrationResolvers.add(new FixedJavaMigrationResolver(sqlScriptFactory, sqlScriptExecutorFactory, configuration.getJavaMigrations()));
        this.migrationResolvers.addAll(customMigrationResolvers);
    }

    public List<ResolvedMigration> resolveMigrations(Context context) {
        if (this.availableMigrations == null) {
            this.availableMigrations = this.doFindAvailableMigrations(context);
        }
        return this.availableMigrations;
    }

    private List<ResolvedMigration> doFindAvailableMigrations(Context context) throws MigrateDbException {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>(DefaultMigrationResolver.collectMigrations(this.migrationResolvers, context));
        migrations.sort(new ResolvedMigrationComparator());
        DefaultMigrationResolver.checkForIncompatibilities(migrations);
        return migrations;
    }

    static Collection<ResolvedMigration> collectMigrations(Collection<MigrationResolver> migrationResolvers, Context context) {
        HashSet<ResolvedMigration> migrations = new HashSet<ResolvedMigration>();
        for (MigrationResolver migrationResolver : migrationResolvers) {
            migrations.addAll(migrationResolver.resolveMigrations(context));
        }
        return migrations;
    }

    static void checkForIncompatibilities(List<ResolvedMigration> migrations) {
        ResolvedMigrationComparator resolvedMigrationComparator = new ResolvedMigrationComparator();
        for (int i = 0; i < migrations.size() - 1; ++i) {
            ResolvedMigration next;
            ResolvedMigration current = migrations.get(i);
            if (resolvedMigrationComparator.compare(current, next = migrations.get(i + 1)) != 0 || current.getType().isBaselineMigration() ^ next.getType().isBaselineMigration()) continue;
            if (current.getVersion() != null) {
                throw new MigrateDbException("Found more than one migration with version " + current.getVersion() + "\nOffenders:\n-> " + current.getLocationDescription() + " (" + current.getType() + ")\n-> " + next.getLocationDescription() + " (" + next.getType() + ")", ErrorCode.DUPLICATE_VERSIONED_MIGRATION);
            }
            throw new MigrateDbException("Found more than one repeatable migration with description " + current.getDescription() + "\nOffenders:\n-> " + current.getLocationDescription() + " (" + current.getType() + ")\n-> " + next.getLocationDescription() + " (" + next.getType() + ")", ErrorCode.DUPLICATE_REPEATABLE_MIGRATION);
        }
    }
}

