/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.jdbc.ExecutionTemplate;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public class TransactionalExecutionTemplate
implements ExecutionTemplate {
    private static final Log LOG = Log.getLog(TransactionalExecutionTemplate.class);
    private final Connection connection;
    private final boolean rollbackOnException;

    public TransactionalExecutionTemplate(Connection connection, boolean rollbackOnException) {
        this.connection = connection;
        this.rollbackOnException = rollbackOnException;
    }

    @Override
    public <T> T execute(Callable<T> callback) {
        boolean oldAutocommit = true;
        try {
            oldAutocommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            T result = callback.call();
            this.connection.commit();
            T t = result;
            return t;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            RuntimeException rethrow = e instanceof SQLException ? new MigrateDbSqlException("Unable to commit transaction", (SQLException)e) : (e instanceof RuntimeException ? (RuntimeException)e : new MigrateDbException(e));
            if (this.rollbackOnException) {
                try {
                    LOG.debug("Rolling back transaction...");
                    this.connection.rollback();
                    LOG.debug("Transaction rolled back");
                }
                catch (SQLException se) {
                    LOG.error("Unable to rollback transaction", se);
                }
            } else {
                try {
                    this.connection.commit();
                }
                catch (SQLException se) {
                    LOG.error("Unable to commit transaction", se);
                }
            }
            throw rethrow;
        }
        finally {
            try {
                this.connection.setAutoCommit(oldAutocommit);
            }
            catch (SQLException e) {
                LOG.error("Unable to restore autocommit to original value for connection", e);
            }
        }
    }
}

