/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import migratedb.v1.core.api.ConnectionProvider;
import migratedb.v1.core.api.DatabaseTypeRegister;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;
import migratedb.v1.core.internal.strategy.BackoffStrategy;
import migratedb.v1.core.internal.util.ExceptionUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JdbcUtils {
    private static final Log LOG = Log.getLog(JdbcUtils.class);

    public static Connection openConnection(ConnectionProvider dataSource, int connectRetries, int connectRetriesInterval, DatabaseTypeRegister databaseTypeRegister) throws MigrateDbException {
        BackoffStrategy backoffStrategy = new BackoffStrategy(1, 2, connectRetriesInterval);
        int retries = 0;
        while (true) {
            try {
                return dataSource.getConnection();
            }
            catch (SQLException e) {
                if ("08S01".equals(e.getSQLState()) && e.getMessage().contains("This driver is not configured for integrated authentication")) {
                    throw new MigrateDbSqlException("Unable to obtain connection from database", e);
                }
                if (e.getSQLState() == null && e.getMessage().contains("MSAL4J")) {
                    throw new MigrateDbSqlException("Unable to obtain connection from database.\nYou need to install some extra drivers in order for interactive authentication to work.", e);
                }
                if (++retries > connectRetries) {
                    throw new MigrateDbSqlException("Unable to obtain connection from database", e);
                }
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                String msg = "Connection error: " + e.getMessage();
                if (rootCause != null && rootCause != e && rootCause.getMessage() != null) {
                    msg = msg + " (Caused by " + rootCause.getMessage() + ")";
                }
                LOG.warn(msg + " Retrying in " + backoffStrategy.peek() + " sec...");
                try {
                    Thread.sleep((long)backoffStrategy.next() * 1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw new MigrateDbSqlException("Unable to obtain connection from database", e);
                }
            }
        }
    }

    public static void closeConnection(@Nullable Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.isClosed()) {
                connection.close();
            }
        }
        catch (RuntimeException | SQLException e) {
            LOG.error("Error while closing database connection: " + e.getMessage(), e);
        }
    }

    public static void closeStatement(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (RuntimeException | SQLException e) {
            LOG.error("Error while closing JDBC statement", e);
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (RuntimeException | SQLException e) {
            LOG.error("Error while closing JDBC resultSet", e);
        }
    }

    public static DatabaseMetaData getDatabaseMetaData(Connection connection) {
        DatabaseMetaData databaseMetaData;
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to read database connection metadata: " + e.getMessage(), e);
        }
        if (databaseMetaData == null) {
            throw new MigrateDbException("Unable to read database connection metadata while it is null!");
        }
        return databaseMetaData;
    }

    public static String getDatabaseProductName(DatabaseMetaData databaseMetaData) {
        try {
            String databaseProductName = databaseMetaData.getDatabaseProductName();
            if (databaseProductName == null) {
                throw new MigrateDbException("Unable to determine database. Product name is null.");
            }
            int databaseMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            int databaseMinorVersion = databaseMetaData.getDatabaseMinorVersion();
            return databaseProductName + " " + databaseMajorVersion + "." + databaseMinorVersion;
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Error while determining database product name", e);
        }
    }

    public static String getDatabaseProductVersion(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Error while determining database product version", e);
        }
    }
}

