/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.sqlserver.synapse;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.sqlserver.SQLServerDatabaseType;
import migratedb.v1.core.internal.database.sqlserver.SQLServerEngineEdition;
import migratedb.v1.core.internal.database.sqlserver.synapse.SynapseDatabase;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public class SynapseDatabaseType
extends SQLServerDatabaseType {
    @Override
    public String getName() {
        return "Azure Synapse";
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        if (databaseProductName.startsWith("Microsoft SQL Server")) {
            try {
                SQLServerEngineEdition engineEdition = SQLServerEngineEdition.fromCode(this.getJdbcTemplate(connection).queryForInt("SELECT SERVERPROPERTY('engineedition')", new String[0]));
                return engineEdition == SQLServerEngineEdition.SQL_DATA_WAREHOUSE;
            }
            catch (SQLException e) {
                throw new MigrateDbSqlException("Unable to determine database engine edition.'", e);
            }
        }
        return false;
    }

    private JdbcTemplate getJdbcTemplate(Connection connection) {
        return new JdbcTemplate(connection, this);
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        return new SynapseDatabase(configuration, jdbcConnectionFactory);
    }
}

