/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.snowflake;

import java.sql.SQLException;
import java.util.List;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.snowflake.SnowflakeDatabase;
import migratedb.v1.core.internal.database.snowflake.SnowflakeTable;

public class SnowflakeSchema
extends BaseSchema {
    SnowflakeSchema(JdbcTemplate jdbcTemplate, SnowflakeDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        List<Boolean> results = this.jdbcTemplate.query("SHOW SCHEMAS LIKE '" + this.name + "'", rs -> true, new Object[0]);
        return !results.isEmpty();
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        int objectCount = this.getObjectCount("TABLE") + this.getObjectCount("VIEW") + this.getObjectCount("SEQUENCE");
        return objectCount == 0;
    }

    private int getObjectCount(String objectType) throws SQLException {
        return this.jdbcTemplate.query("SHOW " + objectType + "S IN SCHEMA " + this.getDatabase().quote(this.name), rs -> 1, new Object[0]).size();
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.getDatabase().quote(this.name), new Object[0]);
    }

    protected List<SnowflakeTable> doAllTables() throws SQLException {
        return this.jdbcTemplate.query("SHOW TABLES IN SCHEMA " + this.getDatabase().quote(this.name), rs -> {
            String tableName = rs.getString("name");
            return this.getTable(tableName);
        }, new Object[0]);
    }

    @Override
    public SnowflakeTable getTable(String tableName) {
        return new SnowflakeTable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }

    @Override
    protected SnowflakeDatabase getDatabase() {
        return (SnowflakeDatabase)super.getDatabase();
    }
}

