/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.saphana;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.saphana.SAPHANADatabase;
import migratedb.v1.core.internal.database.saphana.SAPHANATable;

public class SAPHANASchema
extends BaseSchema {
    SAPHANASchema(JdbcTemplate jdbcTemplate, SAPHANADatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM SYS.SCHEMAS WHERE SCHEMA_NAME=?", this.name) > 0;
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("select count(*) from sys.tables where schema_name = ?", this.name);
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from sys.views where schema_name = ?", this.name);
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from sys.sequences where schema_name = ?", this.name);
        return (objectCount += this.jdbcTemplate.queryForInt("select count(*) from sys.synonyms where schema_name = ?", this.name)) == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.getDatabase().quote(this.name), new Object[0]);
    }

    private List<String> getDbObjects(String objectType) throws SQLException {
        return this.jdbcTemplate.queryForStringList("select " + objectType + "_NAME from SYS." + objectType + "S where SCHEMA_NAME = ?", this.name);
    }

    protected List<SAPHANATable> doAllTables() throws SQLException {
        List<String> tableNames = this.getDbObjects("TABLE");
        ArrayList<SAPHANATable> tables = new ArrayList<SAPHANATable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new SAPHANATable(this.jdbcTemplate, this.getDatabase(), this, tableName));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new SAPHANATable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }

    @Override
    protected SAPHANADatabase getDatabase() {
        return (SAPHANADatabase)super.getDatabase();
    }
}

