/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.redshift;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.redshift.RedshiftDatabase;
import migratedb.v1.core.internal.database.redshift.RedshiftTable;

public class RedshiftSchema
extends BaseSchema {
    RedshiftSchema(JdbcTemplate jdbcTemplate, RedshiftDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM pg_namespace WHERE nspname=?", this.name) > 0;
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (   SELECT 1\n   FROM   pg_catalog.pg_class c\n   JOIN   pg_catalog.pg_namespace n ON n.oid = c.relnamespace\n   WHERE  n.nspname = ?)", this.name);
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.getDatabase().quote(this.name), new Object[0]);
    }

    protected List<RedshiftTable> doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT t.table_name FROM information_schema.tables t WHERE table_schema=? AND table_type='BASE TABLE'", this.name);
        ArrayList<RedshiftTable> tables = new ArrayList<RedshiftTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new RedshiftTable(this.jdbcTemplate, this.database(), this, tableName));
        }
        return tables;
    }

    @Override
    public RedshiftTable getTable(String tableName) {
        return new RedshiftTable(this.jdbcTemplate, this.database(), this, tableName);
    }

    private RedshiftDatabase database() {
        return (RedshiftDatabase)super.getDatabase();
    }
}

