/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.mysql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.mysql.MySQLDatabase;
import migratedb.v1.core.internal.database.mysql.MySQLTable;

public class MySQLSchema
extends BaseSchema {
    MySQLSchema(JdbcTemplate jdbcTemplate, MySQLDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(1) FROM information_schema.schemata WHERE schema_name=? LIMIT 1", this.name) > 0;
    }

    @Override
    protected MySQLDatabase getDatabase() {
        return (MySQLDatabase)super.getDatabase();
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(this.name, this.name, this.name, this.name, this.name));
        if (this.getDatabase().eventSchedulerQueryable) {
            params.add(this.name);
        }
        return this.jdbcTemplate.queryForInt("SELECT SUM(found) FROM ((SELECT 1 as found FROM information_schema.tables WHERE table_schema=?) UNION ALL (SELECT 1 as found FROM information_schema.views WHERE table_schema=? LIMIT 1) UNION ALL (SELECT 1 as found FROM information_schema.table_constraints WHERE table_schema=? LIMIT 1) UNION ALL (SELECT 1 as found FROM information_schema.triggers WHERE event_object_schema=?  LIMIT 1) UNION ALL (SELECT 1 as found FROM information_schema.routines WHERE routine_schema=? LIMIT 1)" + (this.getDatabase().eventSchedulerQueryable ? " UNION ALL (SELECT 1 as found FROM information_schema.events WHERE event_schema=? LIMIT 1)" : "") + ") as all_found", params.toArray(new String[0])) == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.getDatabase().quote(this.name), new Object[0]);
    }

    protected List<MySQLTable> doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT table_name FROM information_schema.tables WHERE table_schema=? AND table_type IN ('BASE TABLE', 'SYSTEM VERSIONED')", this.name);
        ArrayList<MySQLTable> tables = new ArrayList<MySQLTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new MySQLTable(this.jdbcTemplate, this.getDatabase(), this, tableName));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new MySQLTable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }
}

