/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.mysql;

import java.sql.SQLException;
import java.util.concurrent.Callable;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public class MySQLNamedLockTemplate {
    private static final Log LOG = Log.getLog(MySQLNamedLockTemplate.class);
    private final JdbcTemplate jdbcTemplate;
    private final String lockName;

    MySQLNamedLockTemplate(JdbcTemplate jdbcTemplate, int discriminator) {
        this.jdbcTemplate = jdbcTemplate;
        this.lockName = "MigrateDb-" + discriminator;
    }

    public <T> T execute(Callable<T> callable) {
        try {
            this.lock();
            T t = callable.call();
            return t;
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to acquire MySQL named lock: " + this.lockName, e);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            RuntimeException rethrow = e instanceof RuntimeException ? (RuntimeException)e : new MigrateDbException(e);
            throw rethrow;
        }
        finally {
            try {
                this.jdbcTemplate.execute("SELECT RELEASE_LOCK('" + this.lockName + "')", new Object[0]);
            }
            catch (SQLException e) {
                LOG.error("Unable to release MySQL named lock: " + this.lockName, e);
            }
        }
    }

    private void lock() throws SQLException {
        while (!this.tryLock()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new MigrateDbException("Interrupted while attempting to acquire MySQL named lock: " + this.lockName, e);
            }
        }
    }

    private boolean tryLock() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT GET_LOCK(?,10)", this.lockName) == 1;
    }
}

