/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.informix;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.informix.InformixDatabase;
import migratedb.v1.core.internal.database.informix.InformixTable;

public class InformixSchema
extends BaseSchema {
    InformixSchema(JdbcTemplate jdbcTemplate, InformixDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM systables where owner = ? and tabid > 99", this.name) > 0;
    }

    @Override
    protected boolean doCheckIfEmpty() throws SQLException {
        return this.doAllTables().isEmpty();
    }

    @Override
    protected void doCreate() {
    }

    private List<InformixTable> findTables(String sqlQuery, String ... params) throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList(sqlQuery, params);
        ArrayList<InformixTable> tables = new ArrayList<InformixTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new InformixTable(this.jdbcTemplate, this.getDatabase(), this, tableName));
        }
        return tables;
    }

    @Override
    protected InformixDatabase getDatabase() {
        return (InformixDatabase)super.getDatabase();
    }

    protected List<InformixTable> doAllTables() throws SQLException {
        return this.findTables("SELECT t.tabname FROM \"informix\".systables AS t WHERE owner=? AND t.tabid > 99 AND t.tabtype='T' AND t.tabname NOT IN ( 'calendarpatterns', 'calendartable', 'tscontainertable', 'tscontainerwindowtable', 'tsinstancetable',  'tscontainerusageactivewindowvti', 'tscontainerusagedormantwindowvti')", this.name);
    }

    @Override
    public InformixTable getTable(String tableName) {
        return new InformixTable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }
}

