/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.ignite.thin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.database.base.BaseSchema;
import migratedb.v1.core.internal.database.ignite.thin.IgniteThinDatabase;
import migratedb.v1.core.internal.database.ignite.thin.IgniteThinTable;
import migratedb.v1.core.internal.util.StringUtils;

public class IgniteThinSchema
extends BaseSchema {
    IgniteThinSchema(JdbcTemplate jdbcTemplate, IgniteThinDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME=?", this.name) > 0;
    }

    @Override
    protected boolean doCheckIfEmpty() {
        return this.allTables().isEmpty();
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.getDatabase().quote(this.name), new Object[0]);
    }

    protected List<IgniteThinTable> doAllTables() throws SQLException {
        List<String> tableNames = this.listObjectNames("TABLE", "TABLE_TYPE = 'TABLE' AND TABLE_NAME !='__T0'");
        ArrayList<IgniteThinTable> tables = new ArrayList<IgniteThinTable>(tableNames.size());
        for (String tableName : tableNames) {
            tables.add(new IgniteThinTable(this.jdbcTemplate, this.getDatabase(), this, tableName));
        }
        return tables;
    }

    @Override
    protected IgniteThinDatabase getDatabase() {
        return (IgniteThinDatabase)super.getDatabase();
    }

    private List<String> listObjectNames(String objectType, String querySuffix) throws SQLException {
        String query = "SELECT " + objectType + "_NAME FROM INFORMATION_SCHEMA." + objectType + "S WHERE " + objectType + "_SCHEMA = ?";
        if (StringUtils.hasLength(querySuffix)) {
            query = query + " AND " + querySuffix;
        }
        return this.jdbcTemplate.queryForStringList(query, this.name);
    }

    @Override
    public IgniteThinTable getTable(String tableName) {
        return new IgniteThinTable(this.jdbcTemplate, this.getDatabase(), this, tableName);
    }
}

