/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.hsqldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.hsqldb.HSQLDBDatabase;
import migratedb.v1.core.internal.database.hsqldb.HSQLDBSchema;
import migratedb.v1.core.internal.jdbc.JdbcUtils;

public class HSQLDBSession
extends BaseSession {
    HSQLDBSession(HSQLDBDatabase database, Connection connection) {
        super(database, connection);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        ResultSet resultSet = null;
        String schema = null;
        try {
            resultSet = this.getDatabase().getJdbcMetaData().getSchemas();
            while (resultSet.next()) {
                if (!resultSet.getBoolean("IS_DEFAULT")) continue;
                schema = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return schema;
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + this.getDatabase().quote(schema), new Object[0]);
    }

    @Override
    public Schema getSchema(String name) {
        return new HSQLDBSchema(this.jdbcTemplate, this.getDatabase(), name);
    }

    @Override
    public HSQLDBDatabase getDatabase() {
        return (HSQLDBDatabase)super.getDatabase();
    }
}

