/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.h2;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.h2.H2Database;
import migratedb.v1.core.internal.database.h2.H2Schema;

public class H2Session
extends BaseSession {
    private final boolean requiresV2Metadata;

    H2Session(H2Database database, Connection connection, boolean requiresV2Metadata) {
        super(database, connection);
        this.requiresV2Metadata = requiresV2Metadata;
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + this.getDatabase().quote(schema), new Object[0]);
    }

    @Override
    public Schema getSchema(String name) {
        return new H2Schema(this.jdbcTemplate, this.getDatabase(), name, this.requiresV2Metadata);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("CALL SCHEMA()", new String[0]);
    }

    @Override
    public H2Database getDatabase() {
        return (H2Database)super.getDatabase();
    }
}

