/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.h2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.internal.database.base.BaseDatabase;
import migratedb.v1.core.internal.database.h2.H2Session;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;

public class H2Database
extends BaseDatabase {
    private static final String DEFAULT_USER = "<< default user >>";
    private static final String DUMMY_SCRIPT_NAME = "<< history table creation script >>";
    private final boolean requiresV2MetadataColumnNames = super.determineVersion().isAtLeast("2.0.0");
    private final CompatibilityMode compatibilityMode = this.determineCompatibilityMode();

    public H2Database(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        super(configuration, jdbcConnectionFactory);
    }

    @Override
    protected H2Session doGetSession(Connection connection) {
        return new H2Session(this, connection, this.requiresV2MetadataColumnNames);
    }

    @Override
    protected Version determineVersion() {
        String query = this.requiresV2MetadataColumnNames ? "SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'info.BUILD_ID'" : "SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME = 'info.BUILD_ID'";
        try {
            int buildId = this.getMainSession().getJdbcTemplate().queryForInt(query, new String[0]);
            return Version.parse(super.determineVersion() + "." + buildId);
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine H2 build ID", e);
        }
    }

    private CompatibilityMode determineCompatibilityMode() {
        String query = this.requiresV2MetadataColumnNames ? "SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'MODE'" : "SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME = 'MODE'";
        try {
            String mode = this.getMainSession().getJdbcTemplate().queryForString(query, new String[0]);
            if (mode == null || mode.isEmpty()) {
                return CompatibilityMode.REGULAR;
            }
            return new CompatibilityMode(mode);
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine H2 compatibility mode", e);
        }
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("1.2.137");
        this.recommendMigrateDbUpgradeIfNecessary("2.2.999");
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        String script = Objects.equals(this.compatibilityMode, CompatibilityMode.Oracle) ? DUMMY_SCRIPT_NAME : "";
        return "CREATE TABLE IF NOT EXISTS " + table + " (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" VARCHAR(100),\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n    \"execution_time\" INT NOT NULL,\n    \"success\" BOOLEAN NOT NULL,\n    CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY (\"installed_rank\")\n) AS SELECT -1, NULL, '<< MigrateDb Schema History table created >>', 'TABLE', '" + script + "', NULL, '" + this.getInstalledBy() + "', CURRENT_TIMESTAMP, 0, TRUE;\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "CREATE INDEX \"" + table.getSchema().getName() + "\".\"" + table.getName() + "_s_idx\" ON " + table + " (\"success\");";
    }

    @Override
    public String getSelectStatement(Table table) {
        return "SELECT " + this.quote("installed_rank") + "," + this.quote("version") + "," + this.quote("description") + "," + this.quote("type") + "," + this.quote("script") + "," + this.quote("checksum") + "," + this.quote("installed_on") + "," + this.quote("installed_by") + "," + this.quote("execution_time") + "," + this.quote("success") + " FROM " + table + " WHERE " + this.quote("type") + " != 'TABLE' AND " + this.quote("installed_rank") + " > ? ORDER BY " + this.quote("installed_rank");
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        try {
            String user = this.getMainSession().getJdbcTemplate().queryForString("SELECT USER()", new String[0]);
            if (Objects.equals(this.compatibilityMode, CompatibilityMode.Oracle) && (user == null || user.isEmpty())) {
                user = DEFAULT_USER;
            }
            return user;
        }
        catch (RuntimeException e) {
            if (Objects.equals(this.compatibilityMode, CompatibilityMode.Oracle)) {
                return DEFAULT_USER;
            }
            throw e;
        }
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return this.requiresV2MetadataColumnNames ? "FALSE" : "0";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    private static final class CompatibilityMode {
        static final CompatibilityMode REGULAR = new CompatibilityMode("REGULAR");
        static final CompatibilityMode Oracle = new CompatibilityMode("Oracle");
        private final String name;
        private final String lowerName;

        CompatibilityMode(String name) {
            this.name = name;
            this.lowerName = name.toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.lowerName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CompatibilityMode)) {
                return false;
            }
            CompatibilityMode other = (CompatibilityMode)obj;
            return other.lowerName.equals(this.lowerName);
        }
    }
}

