/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.firebird;

import java.sql.Connection;
import java.sql.SQLException;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.internal.database.base.BaseDatabase;
import migratedb.v1.core.internal.database.firebird.FirebirdSession;

public class FirebirdDatabase
extends BaseDatabase {
    public FirebirdDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory) {
        super(configuration, jdbcConnectionFactory);
    }

    @Override
    protected FirebirdSession doGetSession(Connection connection) {
        return new FirebirdSession(this, connection);
    }

    @Override
    public void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("3.0");
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return this.getOpenQuote() + identifier.replace(this.getCloseQuote(), this.getEscapedQuote()) + this.getCloseQuote();
    }

    @Override
    public String getEscapedQuote() {
        return "\"\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        String createScript = "CREATE TABLE " + table + " (\n    \"installed_rank\" INTEGER CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" VARCHAR(100),\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,\n    \"execution_time\" INTEGER NOT NULL,\n    \"success\" SMALLINT NOT NULL\n);\nCREATE INDEX \"" + table.getName() + "_s_idx\" ON " + table + " (\"success\");\n";
        if (baseline) {
            createScript = createScript + "COMMIT RETAIN;\n" + this.getBaselineStatement(table) + ";\n";
        }
        return createScript;
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return this.getMainSession().getJdbcTemplate().queryForString("select CURRENT_USER from RDB$DATABASE", new String[0]);
    }

    @Override
    public boolean usesSingleSession() {
        return true;
    }
}

