/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.cockroachdb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.database.base.BaseSession;
import migratedb.v1.core.internal.database.cockroachdb.CockroachDBDatabase;
import migratedb.v1.core.internal.database.cockroachdb.CockroachDBSchema;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;
import migratedb.v1.core.internal.util.StringUtils;

public class CockroachDBSession
extends BaseSession {
    private static final Log LOG = Log.getLog(CockroachDBSession.class);

    public CockroachDBSession(CockroachDBDatabase database, Connection connection) {
        super(database, connection);
    }

    @Override
    public CockroachDBSchema getSchema(String name) {
        return new CockroachDBSchema(this.jdbcTemplate, this.getDatabase(), name);
    }

    @Override
    public Schema doGetCurrentSchema() throws SQLException {
        if (this.getDatabase().supportsSchemas()) {
            String currentSchema = this.jdbcTemplate.queryForString("SELECT current_schema", new String[0]);
            if (StringUtils.hasText(currentSchema)) {
                return this.getSchema(currentSchema);
            }
            String searchPath = this.getCurrentSchemaNameOrSearchPath();
            if (!StringUtils.hasText(searchPath)) {
                throw new MigrateDbException("Unable to determine current schema as search_path is empty. Set the current schema in currentSchema parameter of the JDBC URL or in MigrateDB's schemas property.");
            }
        }
        return super.doGetCurrentSchema();
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        if (this.getDatabase().supportsSchemas()) {
            String sp = this.jdbcTemplate.queryForString("SHOW search_path", new String[0]);
            if (sp.contains("$user")) {
                LOG.debug("Search path contains $user; removing...");
                ArrayList<String> paths = new ArrayList<String>(Arrays.asList(sp.split(",")));
                paths.remove("$user");
                sp = String.join((CharSequence)",", paths);
            }
            return sp;
        }
        return this.jdbcTemplate.queryForString("SHOW database", new String[0]);
    }

    @Override
    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (schema.getName().equals(this.originalSchemaNameOrSearchPath) || !schema.exists()) {
                return;
            }
            this.doChangeCurrentSchemaOrSearchPathTo(schema.getName());
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Error setting current schema to " + schema, e);
        }
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        if (this.getDatabase().supportsSchemas()) {
            if (!StringUtils.hasLength(schema)) {
                schema = "public";
            }
            this.jdbcTemplate.execute("SET search_path = " + schema, new Object[0]);
        } else {
            if (!StringUtils.hasLength(schema)) {
                schema = "DEFAULT";
            }
            this.jdbcTemplate.execute("SET database = " + schema, new Object[0]);
        }
    }

    @Override
    public CockroachDBDatabase getDatabase() {
        return (CockroachDBDatabase)super.getDatabase();
    }
}

