/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.base;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.database.base.Session;
import migratedb.v1.core.api.internal.database.base.Table;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.internal.exception.MigrateDbSqlException;
import migratedb.v1.core.internal.jdbc.ExecutionTemplateFactory;
import migratedb.v1.core.internal.jdbc.JdbcUtils;

public abstract class BaseSession
implements Session {
    protected JdbcTemplate jdbcTemplate;
    private final Database database;
    private final Connection jdbcConnection;
    private final boolean originalAutoCommit;
    protected final String originalSchemaNameOrSearchPath;

    protected BaseSession(Database database, Connection connection) {
        this.database = database;
        try {
            this.originalAutoCommit = connection.getAutoCommit();
            if (!this.originalAutoCommit) {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to turn on auto-commit for the connection", e);
        }
        this.jdbcConnection = connection;
        this.jdbcTemplate = new JdbcTemplate(this.jdbcConnection, database.getDatabaseType());
        try {
            this.originalSchemaNameOrSearchPath = this.getCurrentSchemaNameOrSearchPath();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine the original schema for the connection", e);
        }
    }

    protected abstract String getCurrentSchemaNameOrSearchPath() throws SQLException;

    @Override
    public Schema getCurrentSchema() {
        try {
            return this.doGetCurrentSchema();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to determine the current schema for the connection", e);
        }
    }

    protected Schema doGetCurrentSchema() throws SQLException {
        return this.getSchema(this.getCurrentSchemaNameOrSearchPath());
    }

    @Override
    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (!schema.exists()) {
                return;
            }
            this.doChangeCurrentSchemaOrSearchPathTo(schema.getName());
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Error setting current schema to " + schema, e);
        }
    }

    protected void doChangeCurrentSchemaOrSearchPathTo(String schemaNameOrSearchPath) throws SQLException {
    }

    @Override
    public <T> T lock(Table table, Callable<T> callable) {
        return ExecutionTemplateFactory.createTableExclusiveExecutionTemplate(this.jdbcTemplate.getConnection(), table, this.database).execute(callable);
    }

    @Override
    public final JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public final void close() {
        try {
            this.restoreOriginalState();
            this.restoreOriginalSchema();
            this.restoreOriginalAutoCommit();
        }
        finally {
            JdbcUtils.closeConnection(this.jdbcConnection);
        }
    }

    private void restoreOriginalSchema() {
        ExecutionTemplateFactory.createExecutionTemplate(this.jdbcConnection, this.database).execute(() -> {
            try {
                this.doChangeCurrentSchemaOrSearchPathTo(this.originalSchemaNameOrSearchPath);
            }
            catch (SQLException e) {
                throw new MigrateDbSqlException("Unable to restore original schema", e);
            }
            return null;
        });
    }

    @Override
    public final void restoreOriginalState() {
        try {
            this.doRestoreOriginalState();
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to restore connection to its original state", e);
        }
    }

    private void restoreOriginalAutoCommit() {
        try {
            this.jdbcConnection.setAutoCommit(this.originalAutoCommit);
        }
        catch (SQLException e) {
            throw new MigrateDbSqlException("Unable to restore connection to its original auto-commit setting", e);
        }
    }

    protected void doRestoreOriginalState() throws SQLException {
    }

    @Override
    public final Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    public Database getDatabase() {
        return this.database;
    }
}

