/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.database.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.callback.CallbackExecutor;
import migratedb.v1.core.api.internal.database.DatabaseExecutionStrategy;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.DatabaseType;
import migratedb.v1.core.api.internal.jdbc.ExecutionTemplate;
import migratedb.v1.core.api.internal.jdbc.JdbcConnectionFactory;
import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.internal.parser.ParsingContext;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.database.DefaultExecutionStrategy;
import migratedb.v1.core.internal.jdbc.JdbcUtils;
import migratedb.v1.core.internal.jdbc.TransactionalExecutionTemplate;
import migratedb.v1.core.internal.parser.BaseParser;
import migratedb.v1.core.internal.sqlscript.DefaultSqlScriptExecutor;
import migratedb.v1.core.internal.sqlscript.ParserSqlScript;
import migratedb.v1.core.internal.sqlscript.SqlScriptMetadataImpl;

public abstract class BaseDatabaseType
implements DatabaseType {
    private static final Log LOG = Log.getLog(BaseDatabaseType.class);
    public static final int DEFAULT_PRIORITY = 0;

    @Override
    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    @Override
    public abstract int getNullType();

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public Database createDatabase(Configuration configuration, boolean printInfo, JdbcConnectionFactory jdbcConnectionFactory) {
        String databaseProductName = jdbcConnectionFactory.getProductName();
        if (printInfo) {
            LOG.info("Database: " + jdbcConnectionFactory.getJdbcUrl() + " (" + databaseProductName + ")");
            LOG.debug("Driver  : " + jdbcConnectionFactory.getDriverInfo());
        }
        Database database = this.createDatabase(configuration, jdbcConnectionFactory);
        String intendedCurrentSchema = configuration.getDefaultSchema();
        if (!database.supportsChangingCurrentSchema() && intendedCurrentSchema != null) {
            LOG.warn(databaseProductName + " does not support setting the schema for the current session. Default schema will NOT be changed to " + intendedCurrentSchema + " !");
        }
        return database;
    }

    @Override
    public abstract Database createDatabase(Configuration var1, JdbcConnectionFactory var2);

    @Override
    public abstract BaseParser createParser(Configuration var1, ResourceProvider var2, ParsingContext var3);

    @Override
    public SqlScriptFactory createSqlScriptFactory(Configuration configuration, ParsingContext parsingContext) {
        return (resource, mixed, resourceProvider) -> new ParserSqlScript(this.createParser(configuration, resourceProvider, parsingContext), resource, SqlScriptMetadataImpl.getMetadataResource(resourceProvider, resource), mixed);
    }

    @Override
    public SqlScriptExecutorFactory createSqlScriptExecutorFactory(JdbcConnectionFactory jdbcConnectionFactory, CallbackExecutor callbackExecutor) {
        BaseDatabaseType thisRef = this;
        return (connection, outputQueryResults) -> new DefaultSqlScriptExecutor(new JdbcTemplate(connection, thisRef), callbackExecutor, outputQueryResults);
    }

    @Override
    public DatabaseExecutionStrategy createExecutionStrategy(Connection connection) {
        return new DefaultExecutionStrategy();
    }

    @Override
    public ExecutionTemplate createTransactionalExecutionTemplate(Connection connection, boolean rollbackOnException) {
        return new TransactionalExecutionTemplate(connection, rollbackOnException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSelectVersionOutput(Connection connection) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        String result = null;
        try {
            statement = connection.prepareStatement("SELECT version()");
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            String string;
            try {
                string = "";
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            return string;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    @Override
    public void alterConnectionAsNeeded(Connection connection, Configuration configuration) {
    }
}

