/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.command;

import java.util.ArrayList;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.callback.Event;
import migratedb.v1.core.api.internal.callback.CallbackExecutor;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.database.base.Schema;
import migratedb.v1.core.api.internal.database.base.Session;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.internal.jdbc.ExecutionTemplateFactory;
import migratedb.v1.core.internal.schemahistory.SchemaHistory;

public class DbSchemas {
    private static final Log LOG = Log.getLog(DbSchemas.class);
    private final Session session;
    private final Schema[] schemas;
    private final SchemaHistory schemaHistory;
    private final Database database;
    private final CallbackExecutor callbackExecutor;

    public DbSchemas(Database database, Schema[] schemas, SchemaHistory schemaHistory, CallbackExecutor callbackExecutor) {
        this.database = database;
        this.session = database.getMainSession();
        this.schemas = schemas;
        this.schemaHistory = schemaHistory;
        this.callbackExecutor = callbackExecutor;
    }

    public void create(boolean baseline) {
        this.callbackExecutor.onEvent(Event.CREATE_SCHEMA);
        int retries = 0;
        while (true) {
            try {
                ExecutionTemplateFactory.createExecutionTemplate(this.session.getJdbcConnection(), this.database).execute(() -> {
                    ArrayList<Schema> createdSchemas = new ArrayList<Schema>();
                    for (Schema schema : this.schemas) {
                        if (!schema.exists()) {
                            if (schema.getName() == null) {
                                throw new MigrateDbException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the defaultSchema property!");
                            }
                            LOG.debug("Creating schema: " + schema);
                            schema.create();
                            createdSchemas.add(schema);
                            continue;
                        }
                        LOG.debug("Skipping creation of existing schema: " + schema);
                    }
                    if (!createdSchemas.isEmpty()) {
                        this.schemaHistory.create(baseline);
                        this.schemaHistory.addSchemasMarker(createdSchemas.toArray(new Schema[0]));
                    }
                    return null;
                });
                return;
            }
            catch (RuntimeException e) {
                if (++retries >= 10) {
                    throw e;
                }
                try {
                    LOG.debug("Schema creation failed. Retrying in 1 sec ...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw new MigrateDbException("Interrupted");
                }
            }
        }
    }
}

