/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.callback;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.callback.Callback;
import migratedb.v1.core.api.callback.Context;
import migratedb.v1.core.api.callback.Event;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.resource.ResourceName;
import migratedb.v1.core.api.internal.sqlscript.SqlScript;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;
import migratedb.v1.core.api.logging.Log;
import migratedb.v1.core.api.resource.Resource;
import migratedb.v1.core.internal.resource.ResourceNameParser;

public class SqlScriptCallbackFactory {
    private static final Log LOG = Log.getLog(SqlScriptCallbackFactory.class);
    private final List<SqlScriptCallback> callbacks = new ArrayList<SqlScriptCallback>();

    public SqlScriptCallbackFactory(ResourceProvider resourceProvider, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Configuration configuration) {
        HashMap<String, SqlScript> callbacksFound = new HashMap<String, SqlScript>();
        LOG.debug("Scanning for SQL callbacks ...");
        Collection<Resource> resources = resourceProvider.getResources("", configuration.getSqlMigrationSuffixes());
        ResourceNameParser resourceNameParser = new ResourceNameParser(configuration);
        for (Resource resource : resources) {
            ResourceName parsedName = resourceNameParser.parse(resource.getLastNameComponent());
            if (!parsedName.isValid()) continue;
            String name = parsedName.getFilenameWithoutSuffix();
            Event event = Event.fromId(parsedName.getPrefix());
            if (event == null) continue;
            SqlScript existing = (SqlScript)callbacksFound.get(name);
            if (existing != null) {
                throw new MigrateDbException("Found more than 1 SQL callback script called " + name + "!\nOffenders:\n-> " + existing.getResource() + "\n-> " + resource);
            }
            SqlScript sqlScript = sqlScriptFactory.createSqlScript(resource, configuration.isMixed(), resourceProvider);
            callbacksFound.put(name, sqlScript);
            this.callbacks.add(new SqlScriptCallback(event, parsedName.getDescription(), sqlScriptExecutorFactory, sqlScript));
        }
        Collections.sort(this.callbacks);
    }

    public List<Callback> getCallbacks() {
        return new ArrayList<Callback>(this.callbacks);
    }

    private static final class SqlScriptCallback
    implements Callback,
    Comparable<SqlScriptCallback> {
        private final Event event;
        private final String description;
        private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
        private final SqlScript sqlScript;

        private SqlScriptCallback(Event event, String description, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScript sqlScript) {
            this.event = event;
            this.description = description;
            this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
            this.sqlScript = sqlScript;
        }

        @Override
        public boolean supports(Event event, Context context) {
            return this.event == event;
        }

        @Override
        public boolean canHandleInTransaction(Event event, Context context) {
            return this.sqlScript.executeInTransaction();
        }

        @Override
        public void handle(Event event, Context context) {
            if (!this.sqlScript.shouldExecute()) {
                LOG.debug("Not executing SQL callback: " + event.getId() + (String)(this.description == null ? "" : " - " + this.description));
                return;
            }
            LOG.info("Executing SQL callback: " + event.getId() + (String)(this.description == null ? "" : " - " + this.description) + (this.sqlScript.executeInTransaction() ? "" : " [non-transactional]"));
            boolean outputQueryResults = false;
            this.sqlScriptExecutorFactory.createSqlScriptExecutor(context.getConnection(), outputQueryResults).execute(this.sqlScript);
        }

        @Override
        public String getCallbackName() {
            return this.description;
        }

        @Override
        public int compareTo(SqlScriptCallback o) {
            int result = this.event.compareTo(o.event);
            if (result == 0) {
                if (this.description == null) {
                    return -1;
                }
                if (o.description == null) {
                    return 1;
                }
                result = this.description.compareTo(o.description);
            }
            return result;
        }
    }
}

