/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.output;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import migratedb.v1.core.api.ConnectionProvider;
import migratedb.v1.core.api.ErrorDetails;
import migratedb.v1.core.api.MigrationInfo;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.internal.database.base.Database;
import migratedb.v1.core.api.internal.schemahistory.AppliedMigration;
import migratedb.v1.core.api.output.BaselineResult;
import migratedb.v1.core.api.output.InfoOutput;
import migratedb.v1.core.api.output.InfoResult;
import migratedb.v1.core.api.output.LiberateAction;
import migratedb.v1.core.api.output.LiberateResult;
import migratedb.v1.core.api.output.MigrateOutput;
import migratedb.v1.core.api.output.MigrateResult;
import migratedb.v1.core.api.output.RepairOutput;
import migratedb.v1.core.api.output.RepairResult;
import migratedb.v1.core.api.output.ValidateOutput;
import migratedb.v1.core.api.output.ValidateResult;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CommandResultFactory {
    public static LiberateResult createLiberateResult(Configuration configuration, Database database, String schemaHistorySchema, String schemaHistoryTable, List<LiberateAction> changes) {
        return new LiberateResult("1.2.0", CommandResultFactory.getDatabaseName(configuration.getDataSource(), database), schemaHistorySchema, configuration.getOldTable(), schemaHistoryTable, changes);
    }

    public static InfoResult createInfoResult(Configuration configuration, Database database, MigrationInfo[] migrationInfos, MigrationInfo current, boolean allSchemasEmpty) {
        String migratedbVersion = "1.2.0";
        String databaseName = CommandResultFactory.getDatabaseName(configuration.getDataSource(), database);
        ArrayList<InfoOutput> infoOutputs = new ArrayList<InfoOutput>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            infoOutputs.add(CommandResultFactory.createInfoOutput(migrationInfo));
        }
        Version currentSchemaVersion = current == null ? null : current.getVersion();
        String schemaVersion = CommandResultFactory.convertToString(currentSchemaVersion == null ? "<< Empty Schema >>" : currentSchemaVersion);
        return new InfoResult(migratedbVersion, databaseName, schemaVersion, String.join((CharSequence)", ", configuration.getSchemas()), infoOutputs, allSchemasEmpty);
    }

    public static MigrateResult createMigrateResult(String databaseName, Configuration configuration) {
        String migratedbVersion = "1.2.0";
        return new MigrateResult(migratedbVersion, databaseName, String.join((CharSequence)", ", configuration.getSchemas()));
    }

    public static BaselineResult createBaselineResult(String databaseName) {
        String migratedbVersion = "1.2.0";
        return new BaselineResult(migratedbVersion, databaseName);
    }

    public static ValidateResult createValidateResult(String databaseName, ErrorDetails errorDetails, int validationCount, List<ValidateOutput> invalidMigrations, List<String> warnings) {
        String migratedbVersion = "1.2.0";
        boolean validationSuccessful = errorDetails == null;
        return new ValidateResult(migratedbVersion, databaseName, errorDetails, validationSuccessful, validationCount, invalidMigrations, warnings);
    }

    public static RepairResult createRepairResult(Configuration configuration, Database database) {
        String migratedbVersion = "1.2.0";
        return new RepairResult(migratedbVersion, CommandResultFactory.getDatabaseName(configuration.getDataSource(), database));
    }

    public static InfoOutput createInfoOutput(MigrationInfo migrationInfo) {
        return new InfoOutput(CommandResultFactory.getCategory(migrationInfo), CommandResultFactory.convertToString(migrationInfo.getVersion()), migrationInfo.getDescription(), CommandResultFactory.convertToString((Object)migrationInfo.getType()), CommandResultFactory.convertToString(migrationInfo.getInstalledOn()), migrationInfo.getState().getDisplayName(), CommandResultFactory.convertToString(migrationInfo.getPhysicalLocation()), CommandResultFactory.convertToString(migrationInfo.getInstalledBy()), migrationInfo.getExecutionTime() != null ? migrationInfo.getExecutionTime() : 0);
    }

    public static MigrateOutput createMigrateOutput(MigrationInfo migrationInfo, int executionTime) {
        return new MigrateOutput(CommandResultFactory.getCategory(migrationInfo), CommandResultFactory.convertToString(migrationInfo.getVersion()), migrationInfo.getDescription(), CommandResultFactory.convertToString((Object)migrationInfo.getType()), CommandResultFactory.convertToString(migrationInfo.getPhysicalLocation()), executionTime);
    }

    public static ValidateOutput createValidateOutput(MigrationInfo migrationInfo, ErrorDetails validateError) {
        return new ValidateOutput(CommandResultFactory.convertToString(migrationInfo.getVersion()), migrationInfo.getDescription(), CommandResultFactory.convertToString(migrationInfo.getPhysicalLocation()), validateError);
    }

    public static RepairOutput createRepairOutput(MigrationInfo migrationInfo) {
        return new RepairOutput(CommandResultFactory.convertToString(migrationInfo.getVersion()), migrationInfo.getDescription(), migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "");
    }

    public static RepairOutput createRepairOutput(AppliedMigration am) {
        return new RepairOutput(CommandResultFactory.convertToString(am.getVersion()), am.getDescription(), "");
    }

    private static String getDatabaseName(ConnectionProvider connectionProvider, Database database) {
        try {
            return database.getCatalog();
        }
        catch (RuntimeException e) {
            String string;
            block10: {
                Connection connection = connectionProvider.getConnection();
                try {
                    String catalog = connection.getCatalog();
                    String string2 = string = catalog != null ? catalog : "";
                    if (connection == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException | SQLException e1) {
                        return "";
                    }
                }
                connection.close();
            }
            return string;
        }
    }

    private static String convertToString(@Nullable Object value) {
        return CommandResultFactory.convertToString(value, Object::toString);
    }

    private static <T> String convertToString(@Nullable T value, Function<? super T, String> transform) {
        if (value == null) {
            return "";
        }
        String transformed = transform.apply(value);
        return transformed == null ? "" : transformed;
    }

    private static String getCategory(MigrationInfo migrationInfo) {
        if (migrationInfo.getType().isExclusiveToAppliedMigrations()) {
            return "";
        }
        if (migrationInfo.getVersion() == null) {
            return "Repeatable";
        }
        return "Versioned";
    }
}

