/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.migration;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Consumer;
import migratedb.v1.core.api.Checksum;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.migration.BaseJavaMigration;
import migratedb.v1.core.api.migration.Context;
import migratedb.v1.core.internal.parser.PlaceholderReplacingReader;

public abstract class ScriptMigration
extends BaseJavaMigration {
    protected abstract Object script();

    @Override
    public Checksum getChecksum(Configuration configuration) {
        Checksum.Builder checksum = Checksum.builder();
        this.withScript(configuration, checksum::addLines);
        return checksum.build();
    }

    @Override
    public final void migrate(Context context) throws Exception {
        this.withScript(context.getConfiguration(), context::runScript);
    }

    private void withScript(Configuration configuration, Consumer<Reader> consumer) {
        Object script = this.script();
        try (Reader reader = script instanceof Reader ? (Reader)script : new StringReader(script.toString());
             PlaceholderReplacingReader placeholderReplacingReader = new PlaceholderReplacingReader(configuration.getPlaceholderPrefix(), configuration.getPlaceholderSuffix(), configuration.getPlaceholders(), reader);){
            consumer.accept(placeholderReplacingReader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

