/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.migration;

import java.math.BigInteger;
import migratedb.v1.core.api.Checksum;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.migration.Context;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface JavaMigration {
    public @Nullable Version getVersion();

    public String getDescription();

    @Deprecated(forRemoval=true)
    default public @Nullable Integer getChecksum() {
        return null;
    }

    default public @Nullable Checksum getChecksum(Configuration configuration) {
        Integer oldChecksum = this.getChecksum();
        return Checksum.builder().addNumber(oldChecksum == null ? null : BigInteger.valueOf(oldChecksum.intValue())).build();
    }

    public boolean isBaselineMigration();

    public boolean canExecuteInTransaction();

    public void migrate(Context var1) throws Exception;
}

