/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.api.configuration;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import migratedb.v1.core.MigrateDb;
import migratedb.v1.core.api.ClassProvider;
import migratedb.v1.core.api.ConnectionProvider;
import migratedb.v1.core.api.DatabaseTypeRegister;
import migratedb.v1.core.api.ExtensionConfig;
import migratedb.v1.core.api.Location;
import migratedb.v1.core.api.MigrateDbExtension;
import migratedb.v1.core.api.MigrationPattern;
import migratedb.v1.core.api.ResourceProvider;
import migratedb.v1.core.api.TargetVersion;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.callback.Callback;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.configuration.DefaultConfiguration;
import migratedb.v1.core.api.logging.LogSystem;
import migratedb.v1.core.api.logging.LogSystems;
import migratedb.v1.core.api.migration.JavaMigration;
import migratedb.v1.core.api.pattern.ValidatePattern;
import migratedb.v1.core.api.resolver.MigrationResolver;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FluentConfiguration
implements Configuration {
    private final DefaultConfiguration config;

    public FluentConfiguration() {
        this(new DefaultConfiguration());
    }

    public FluentConfiguration(@Nullable ClassLoader classLoader) {
        this(new DefaultConfiguration(classLoader));
    }

    FluentConfiguration(DefaultConfiguration config) {
        this.config = Objects.requireNonNull(config);
    }

    public MigrateDb load() {
        return new MigrateDb(this.config);
    }

    public FluentConfiguration configuration(Configuration configuration) {
        this.config.configure(configuration);
        return this;
    }

    @Override
    public List<Location> getLocations() {
        return this.config.getLocations();
    }

    @Override
    public Charset getEncoding() {
        return this.config.getEncoding();
    }

    @Override
    public String getDefaultSchema() {
        return this.config.getDefaultSchema();
    }

    @Override
    public List<String> getSchemas() {
        return this.config.getSchemas();
    }

    @Override
    public String getTable() {
        return this.config.getTable();
    }

    @Override
    public @Nullable String getOldTable() {
        return this.config.getOldTable();
    }

    @Override
    public boolean isLiberateOnMigrate() {
        return this.config.isLiberateOnMigrate();
    }

    @Override
    public @Nullable String getTablespace() {
        return this.config.getTablespace();
    }

    @Override
    public LogSystem getLogger() {
        return this.config.getLogger();
    }

    @Override
    public TargetVersion getTarget() {
        return this.config.getTarget();
    }

    @Override
    public boolean isFailOnMissingTarget() {
        return this.config.isFailOnMissingTarget();
    }

    @Override
    public List<MigrationPattern> getCherryPick() {
        return this.config.getCherryPick();
    }

    @Override
    public boolean isPlaceholderReplacement() {
        return this.config.isPlaceholderReplacement();
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return this.config.getPlaceholders();
    }

    @Override
    public String getPlaceholderPrefix() {
        return this.config.getPlaceholderPrefix();
    }

    @Override
    public String getPlaceholderSuffix() {
        return this.config.getPlaceholderSuffix();
    }

    @Override
    public String getScriptPlaceholderPrefix() {
        return this.config.getScriptPlaceholderPrefix();
    }

    @Override
    public String getScriptPlaceholderSuffix() {
        return this.config.getScriptPlaceholderSuffix();
    }

    @Override
    public String getSqlMigrationPrefix() {
        return this.config.getSqlMigrationPrefix();
    }

    @Override
    public String getBaselineMigrationPrefix() {
        return this.config.getBaselineMigrationPrefix();
    }

    @Override
    public String getRepeatableSqlMigrationPrefix() {
        return this.config.getRepeatableSqlMigrationPrefix();
    }

    @Override
    public String getSqlMigrationSeparator() {
        return this.config.getSqlMigrationSeparator();
    }

    @Override
    public List<String> getSqlMigrationSuffixes() {
        return this.config.getSqlMigrationSuffixes();
    }

    @Override
    public List<JavaMigration> getJavaMigrations() {
        return this.config.getJavaMigrations();
    }

    @Override
    public boolean isIgnoreMissingMigrations() {
        return this.config.isIgnoreMissingMigrations();
    }

    @Override
    public boolean isIgnoreIgnoredMigrations() {
        return this.config.isIgnoreIgnoredMigrations();
    }

    @Override
    public boolean isIgnorePendingMigrations() {
        return this.config.isIgnorePendingMigrations();
    }

    @Override
    public boolean isIgnoreFutureMigrations() {
        return this.config.isIgnoreFutureMigrations();
    }

    @Override
    public List<ValidatePattern> getIgnoreMigrationPatterns() {
        return this.config.getIgnoreMigrationPatterns();
    }

    @Override
    public boolean isValidateMigrationNaming() {
        return this.config.isValidateMigrationNaming();
    }

    @Override
    public boolean isValidateOnMigrate() {
        return this.config.isValidateOnMigrate();
    }

    @Override
    public Version getBaselineVersion() {
        return this.config.getBaselineVersion();
    }

    @Override
    public String getBaselineDescription() {
        return this.config.getBaselineDescription();
    }

    @Override
    public boolean isBaselineOnMigrate() {
        return this.config.isBaselineOnMigrate();
    }

    @Override
    public boolean isOutOfOrder() {
        return this.config.isOutOfOrder();
    }

    @Override
    public boolean isSkipExecutingMigrations() {
        return this.config.isSkipExecutingMigrations();
    }

    @Override
    public List<MigrationResolver> getResolvers() {
        return this.config.getResolvers();
    }

    @Override
    public boolean isSkipDefaultResolvers() {
        return this.config.isSkipDefaultResolvers();
    }

    @Override
    public @Nullable ConnectionProvider getDataSource() {
        return this.config.getDataSource();
    }

    @Override
    public int getConnectRetries() {
        return this.config.getConnectRetries();
    }

    @Override
    public int getConnectRetriesInterval() {
        return this.config.getConnectRetriesInterval();
    }

    @Override
    public String getInitSql() {
        return this.config.getInitSql();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.config.getClassLoader();
    }

    @Override
    public boolean isMixed() {
        return this.config.isMixed();
    }

    @Override
    public String getInstalledBy() {
        return this.config.getInstalledBy();
    }

    @Override
    public boolean isGroup() {
        return this.config.isGroup();
    }

    @Override
    public ResourceProvider getResourceProvider() {
        return this.config.getResourceProvider();
    }

    @Override
    public ClassProvider<JavaMigration> getJavaMigrationClassProvider() {
        return this.config.getJavaMigrationClassProvider();
    }

    @Override
    public boolean isOutputQueryResults() {
        return this.config.isOutputQueryResults();
    }

    @Override
    public boolean isCreateSchemas() {
        return this.config.isCreateSchemas();
    }

    @Override
    public int getLockRetryCount() {
        return this.config.getLockRetryCount();
    }

    @Override
    public boolean isFailOnMissingLocations() {
        return this.config.isFailOnMissingLocations();
    }

    @Override
    public DatabaseTypeRegister getDatabaseTypeRegister() {
        return this.config.getDatabaseTypeRegister();
    }

    @Override
    public Set<MigrateDbExtension> getLoadedExtensions() {
        return this.config.getLoadedExtensions();
    }

    @Override
    public Map<Class<? extends ExtensionConfig>, ? extends ExtensionConfig> getExtensionConfig() {
        return this.config.getExtensionConfig();
    }

    @Override
    public List<Callback> getCallbacks() {
        return this.config.getCallbacks();
    }

    @Override
    public boolean isSkipDefaultCallbacks() {
        return this.config.isSkipDefaultCallbacks();
    }

    public FluentConfiguration group(boolean group) {
        this.config.setGroup(group);
        return this;
    }

    public FluentConfiguration installedBy(String installedBy) {
        this.config.setInstalledBy(installedBy);
        return this;
    }

    public FluentConfiguration logger(LogSystem logger) {
        this.config.setLogger(logger);
        return this;
    }

    public FluentConfiguration logger(String ... logger) {
        return this.logger(LogSystems.fromStrings(Set.of(logger), this.getClassLoader(), null));
    }

    public FluentConfiguration mixed(boolean mixed) {
        this.config.setMixed(mixed);
        return this;
    }

    public FluentConfiguration ignoreMissingMigrations(boolean ignoreMissingMigrations) {
        this.config.setIgnoreMissingMigrations(ignoreMissingMigrations);
        return this;
    }

    public FluentConfiguration ignoreIgnoredMigrations(boolean ignoreIgnoredMigrations) {
        this.config.setIgnoreIgnoredMigrations(ignoreIgnoredMigrations);
        return this;
    }

    public FluentConfiguration ignorePendingMigrations(boolean ignorePendingMigrations) {
        this.config.setIgnorePendingMigrations(ignorePendingMigrations);
        return this;
    }

    public FluentConfiguration ignoreFutureMigrations(boolean ignoreFutureMigrations) {
        this.config.setIgnoreFutureMigrations(ignoreFutureMigrations);
        return this;
    }

    public FluentConfiguration ignoreMigrationPatternsAsStrings(String ... ignoreMigrationPatterns) {
        this.config.setIgnoreMigrationPatternsAsStrings(ignoreMigrationPatterns);
        return this;
    }

    public FluentConfiguration ignoreMigrationPatternsAsStrings(Collection<String> ignoreMigrationPatterns) {
        this.config.setIgnoreMigrationPatternsAsStrings(ignoreMigrationPatterns);
        return this;
    }

    public FluentConfiguration ignoreMigrationPatterns(ValidatePattern ... ignoreMigrationPatterns) {
        this.config.setIgnoreMigrationPatterns(ignoreMigrationPatterns);
        return this;
    }

    public FluentConfiguration ignoreMigrationPatterns(Collection<ValidatePattern> ignoreMigrationPatterns) {
        this.config.setIgnoreMigrationPatterns(ignoreMigrationPatterns);
        return this;
    }

    public FluentConfiguration validateMigrationNaming(boolean validateMigrationNaming) {
        this.config.setValidateMigrationNaming(validateMigrationNaming);
        return this;
    }

    public FluentConfiguration validateOnMigrate(boolean validateOnMigrate) {
        this.config.setValidateOnMigrate(validateOnMigrate);
        return this;
    }

    public FluentConfiguration locations(String ... locations) {
        this.config.setLocationsAsStrings(locations);
        return this;
    }

    public FluentConfiguration locations(Location ... locations) {
        this.config.setLocations(locations);
        return this;
    }

    public FluentConfiguration locations(Collection<Location> locations) {
        this.config.setLocations(locations);
        return this;
    }

    public FluentConfiguration encoding(String encoding) {
        this.config.setEncodingAsString(encoding);
        return this;
    }

    public FluentConfiguration encoding(Charset encoding) {
        this.config.setEncoding(encoding);
        return this;
    }

    public FluentConfiguration defaultSchema(String schema) {
        this.config.setDefaultSchema(schema);
        return this;
    }

    public FluentConfiguration schemas(String ... schemas) {
        this.config.setSchemas(schemas);
        return this;
    }

    public FluentConfiguration schemas(Collection<String> schemas) {
        this.config.setSchemas(schemas);
        return this;
    }

    public FluentConfiguration table(String table) {
        this.config.setTable(table);
        return this;
    }

    public FluentConfiguration oldTable(String oldTable) {
        this.config.setOldTable(oldTable);
        return this;
    }

    public FluentConfiguration liberateOnMigrate(boolean liberateOnMigrate) {
        this.config.setLiberateOnMigrate(liberateOnMigrate);
        return this;
    }

    public FluentConfiguration tablespace(@Nullable String tablespace) {
        this.config.setTablespace(tablespace);
        return this;
    }

    public FluentConfiguration target(TargetVersion target) {
        this.config.setTarget(target);
        return this;
    }

    public FluentConfiguration target(Version target) {
        this.config.setTarget(TargetVersion.of(target));
        return this;
    }

    public FluentConfiguration target(String target) {
        this.config.setTargetAsString(target);
        return this;
    }

    public FluentConfiguration cherryPick(MigrationPattern ... cherryPick) {
        this.config.setCherryPick(cherryPick);
        return this;
    }

    public FluentConfiguration cherryPick(Collection<MigrationPattern> cherryPick) {
        this.config.setCherryPick(cherryPick);
        return this;
    }

    public FluentConfiguration cherryPick(String ... cherryPickAsString) {
        this.config.setCherryPickAsString(cherryPickAsString);
        return this;
    }

    public FluentConfiguration placeholderReplacement(boolean placeholderReplacement) {
        this.config.setPlaceholderReplacement(placeholderReplacement);
        return this;
    }

    public FluentConfiguration placeholders(Map<String, String> placeholders) {
        this.config.setPlaceholders(placeholders);
        return this;
    }

    public FluentConfiguration placeholderPrefix(String placeholderPrefix) {
        this.config.setPlaceholderPrefix(placeholderPrefix);
        return this;
    }

    public FluentConfiguration placeholderSuffix(String placeholderSuffix) {
        this.config.setPlaceholderSuffix(placeholderSuffix);
        return this;
    }

    public FluentConfiguration scriptPlaceholderPrefix(String scriptPlaceholderPrefix) {
        this.config.setScriptPlaceholderPrefix(scriptPlaceholderPrefix);
        return this;
    }

    public FluentConfiguration scriptPlaceholderSuffix(String scriptPlaceholderSuffix) {
        this.config.setScriptPlaceholderSuffix(scriptPlaceholderSuffix);
        return this;
    }

    public FluentConfiguration sqlMigrationPrefix(String sqlMigrationPrefix) {
        this.config.setSqlMigrationPrefix(sqlMigrationPrefix);
        return this;
    }

    public FluentConfiguration baselineMigrationPrefix(String baselineMigrationPrefix) {
        this.config.setBaselineMigrationPrefix(baselineMigrationPrefix);
        return this;
    }

    public FluentConfiguration repeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.config.setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefix);
        return this;
    }

    public FluentConfiguration sqlMigrationSeparator(String sqlMigrationSeparator) {
        this.config.setSqlMigrationSeparator(sqlMigrationSeparator);
        return this;
    }

    public FluentConfiguration sqlMigrationSuffixes(String ... sqlMigrationSuffixes) {
        this.config.setSqlMigrationSuffixes(sqlMigrationSuffixes);
        return this;
    }

    public FluentConfiguration sqlMigrationSuffixes(Collection<String> sqlMigrationSuffixes) {
        this.config.setSqlMigrationSuffixes(sqlMigrationSuffixes);
        return this;
    }

    public FluentConfiguration javaMigrations(JavaMigration ... javaMigrations) {
        this.config.setJavaMigrations(Arrays.asList(javaMigrations));
        return this;
    }

    public FluentConfiguration javaMigrations(Collection<JavaMigration> javaMigrations) {
        this.config.setJavaMigrations(javaMigrations);
        return this;
    }

    public FluentConfiguration dataSource(DataSource dataSource) {
        this.config.setDataSource(dataSource);
        return this;
    }

    public FluentConfiguration dataSource(ConnectionProvider dataSource) {
        this.config.setDataSource(dataSource);
        return this;
    }

    public FluentConfiguration connectRetries(int connectRetries) {
        this.config.setConnectRetries(connectRetries);
        return this;
    }

    public FluentConfiguration connectRetriesInterval(int connectRetriesInterval) {
        this.config.setConnectRetriesInterval(connectRetriesInterval);
        return this;
    }

    public FluentConfiguration initSql(String initSql) {
        this.config.setInitSql(initSql);
        return this;
    }

    public FluentConfiguration baselineVersion(Version baselineVersion) {
        this.config.setBaselineVersion(baselineVersion);
        return this;
    }

    public FluentConfiguration baselineVersion(String baselineVersion) {
        this.config.setBaselineVersion(Version.parse(baselineVersion));
        return this;
    }

    public FluentConfiguration baselineDescription(String baselineDescription) {
        this.config.setBaselineDescription(baselineDescription);
        return this;
    }

    public FluentConfiguration baselineOnMigrate(boolean baselineOnMigrate) {
        this.config.setBaselineOnMigrate(baselineOnMigrate);
        return this;
    }

    public FluentConfiguration outOfOrder(boolean outOfOrder) {
        this.config.setOutOfOrder(outOfOrder);
        return this;
    }

    public FluentConfiguration skipExecutingMigrations(boolean skipExecutingMigrations) {
        this.config.setSkipExecutingMigrations(skipExecutingMigrations);
        return this;
    }

    public FluentConfiguration callbacks(Callback ... callbacks) {
        this.config.setCallbacks(callbacks);
        return this;
    }

    public FluentConfiguration callbacks(Collection<Callback> callbacks) {
        this.config.setCallbacks(callbacks);
        return this;
    }

    public FluentConfiguration callbacks(String ... callbacks) {
        this.config.setCallbacksAsClassNames(callbacks);
        return this;
    }

    public FluentConfiguration skipDefaultCallbacks(boolean skipDefaultCallbacks) {
        this.config.setSkipDefaultCallbacks(skipDefaultCallbacks);
        return this;
    }

    public FluentConfiguration resolvers(MigrationResolver ... resolvers) {
        this.config.setResolvers(resolvers);
        return this;
    }

    public FluentConfiguration resolvers(Collection<MigrationResolver> resolvers) {
        this.config.setResolvers(resolvers);
        return this;
    }

    public FluentConfiguration resolvers(String ... resolvers) {
        this.config.setResolversAsClassNames(resolvers);
        return this;
    }

    public FluentConfiguration skipDefaultResolvers(boolean skipDefaultResolvers) {
        this.config.setSkipDefaultResolvers(skipDefaultResolvers);
        return this;
    }

    public FluentConfiguration lockRetryCount(int lockRetryCount) {
        this.config.setLockRetryCount(lockRetryCount);
        return this;
    }

    public <T extends ExtensionConfig> FluentConfiguration extensionConfig(Class<T> extensionConfigType, T value) {
        this.config.setExtensionConfig(extensionConfigType, value);
        return this;
    }

    public FluentConfiguration resourceProvider(ResourceProvider resourceProvider) {
        this.config.setResourceProvider(resourceProvider);
        return this;
    }

    public FluentConfiguration javaMigrationClassProvider(ClassProvider<JavaMigration> javaMigrationClassProvider) {
        this.config.setJavaMigrationClassProvider(javaMigrationClassProvider);
        return this;
    }

    public FluentConfiguration outputQueryResults(boolean outputQueryResults) {
        this.config.setOutputQueryResults(outputQueryResults);
        return this;
    }

    public FluentConfiguration configuration(Properties properties) {
        this.config.configure(properties);
        return this;
    }

    public FluentConfiguration configuration(Map<String, String> props) {
        this.config.configure(props);
        return this;
    }

    public FluentConfiguration createSchemas(boolean createSchemas) {
        this.config.setCreateSchemas(createSchemas);
        return this;
    }

    public FluentConfiguration failOnMissingLocations(boolean failOnMissingLocations) {
        this.config.setFailOnMissingLocations(failOnMissingLocations);
        return this;
    }

    public FluentConfiguration useExtension(MigrateDbExtension extension) {
        this.config.useExtension(extension);
        return this;
    }

    public FluentConfiguration useExtensions(Iterable<MigrateDbExtension> extensions) {
        this.config.useExtensions(extensions);
        return this;
    }
}

