/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.sqlscript;

import migratedb.v1.core.api.internal.jdbc.JdbcTemplate;
import migratedb.v1.core.api.internal.jdbc.Results;
import migratedb.v1.core.api.internal.sqlscript.Delimiter;
import migratedb.v1.core.api.internal.sqlscript.SqlStatement;

public class ParsedSqlStatement
implements SqlStatement {
    private final int pos;
    private final int line;
    private final int col;
    private final String sql;
    private final Delimiter delimiter;
    private final boolean canExecuteInTransaction;

    public int getPos() {
        return this.pos;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public ParsedSqlStatement(int pos, int line, int col, String sql, Delimiter delimiter, boolean canExecuteInTransaction) {
        this.pos = pos;
        this.line = line;
        this.col = col;
        this.sql = sql;
        this.delimiter = delimiter;
        this.canExecuteInTransaction = canExecuteInTransaction;
    }

    @Override
    public final int getLineNumber() {
        return this.line;
    }

    @Override
    public final String getSql() {
        return this.sql;
    }

    @Override
    public String getDelimiter() {
        return this.delimiter.toString();
    }

    @Override
    public boolean canExecuteInTransaction() {
        return this.canExecuteInTransaction;
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate) {
        return jdbcTemplate.executeStatement(this.sql);
    }
}

