/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resource.filesystem;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.resource.Resource;

public class FileSystemResource
implements Resource {
    private final Path file;
    private final String relativeName;

    public FileSystemResource(Path file, Path relativeTo) {
        this.file = file.toAbsolutePath().normalize();
        Path relativized = FileSystemResource.tryRelativize(file, relativeTo.toAbsolutePath().normalize());
        ArrayList<String> segments = new ArrayList<String>();
        for (Path segment : relativized) {
            segments.add(segment.toString());
        }
        this.relativeName = String.join((CharSequence)"/", segments);
    }

    private static Path tryRelativize(Path file, Path relativeTo) {
        if (file.equals(relativeTo)) {
            return file;
        }
        try {
            return relativeTo.relativize(file);
        }
        catch (RuntimeException e) {
            return file;
        }
    }

    @Override
    public Reader read(Charset charset) {
        try {
            return Files.newBufferedReader(this.file, charset);
        }
        catch (IOException e) {
            throw new MigrateDbException("Cannot open file system resource " + this.getName(), e);
        }
    }

    @Override
    public String getName() {
        return this.relativeName;
    }

    @Override
    public String describeLocation() {
        return "file: " + this.file;
    }

    public String toString() {
        return this.describeLocation();
    }
}

