/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resource.classpath;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.resource.Resource;

public class ClassPathResource
implements Resource {
    private final ClassLoader classLoader;
    private final String name;

    public ClassPathResource(String name, ClassLoader classLoader) {
        this.name = name;
        this.classLoader = classLoader;
    }

    @Override
    public Reader read(Charset charset) {
        InputStream stream = this.classLoader.getResourceAsStream(this.name);
        if (stream == null) {
            throw new MigrateDbException("No such resource: " + this.name);
        }
        return new InputStreamReader(stream, charset);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String describeLocation() {
        URL resource = this.classLoader.getResource(this.name);
        return "classpath: " + this.name + " (" + resource + ")";
    }

    public String toString() {
        return this.describeLocation();
    }
}

