/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.core.internal.resolver.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptExecutorFactory;
import migratedb.v1.core.api.internal.sqlscript.SqlScriptFactory;
import migratedb.v1.core.api.migration.JavaMigration;
import migratedb.v1.core.api.resolver.Context;
import migratedb.v1.core.api.resolver.MigrationResolver;
import migratedb.v1.core.api.resolver.ResolvedMigration;
import migratedb.v1.core.internal.resolver.ResolvedMigrationComparator;
import migratedb.v1.core.internal.resolver.java.JavaMigrationResolver;

public class FixedJavaMigrationResolver
implements MigrationResolver {
    private final Collection<JavaMigration> javaMigrations;
    private final SqlScriptFactory sqlScriptFactory;
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;

    public FixedJavaMigrationResolver(SqlScriptFactory sqlScriptFactory, SqlScriptExecutorFactory sqlScriptExecutorFactory, Collection<JavaMigration> javaMigrations) {
        this.sqlScriptFactory = sqlScriptFactory;
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
        this.javaMigrations = javaMigrations;
    }

    public List<ResolvedMigration> resolveMigrations(Context context) {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        for (JavaMigration javaMigration : this.javaMigrations) {
            migrations.add(JavaMigrationResolver.newResolvedJavaMigration(javaMigration, context.getConfiguration(), this.sqlScriptFactory, this.sqlScriptExecutorFactory));
        }
        migrations.sort(new ResolvedMigrationComparator());
        return migrations;
    }
}

